/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import java.net.URI;
import java.util.Collections;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2UserRequestEntityConverter
implements Converter<OAuth2UserRequest, RequestEntity<?>> {
    private static final MediaType DEFAULT_CONTENT_TYPE = MediaType.valueOf((String)"application/x-www-form-urlencoded;charset=UTF-8");

    public RequestEntity<?> convert(OAuth2UserRequest userRequest) {
        RequestEntity request;
        ClientRegistration clientRegistration = userRequest.getClientRegistration();
        HttpMethod httpMethod = HttpMethod.GET;
        if (AuthenticationMethod.FORM.equals((Object)clientRegistration.getProviderDetails().getUserInfoEndpoint().getAuthenticationMethod())) {
            httpMethod = HttpMethod.POST;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        URI uri = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getUserInfoEndpoint().getUri()).build().toUri();
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            headers.setContentType(DEFAULT_CONTENT_TYPE);
            LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
            formParameters.add((Object)"access_token", (Object)userRequest.getAccessToken().getTokenValue());
            request = new RequestEntity((Object)formParameters, (MultiValueMap)headers, httpMethod, uri);
        } else {
            headers.setBearerAuth(userRequest.getAccessToken().getTokenValue());
            request = new RequestEntity((MultiValueMap)headers, httpMethod, uri);
        }
        return request;
    }
}

