/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.test.assertj;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.springframework.statemachine.StateMachine;

public class StateMachineAssert
extends AbstractAssert<StateMachineAssert, StateMachine<?, ?>> {
    public StateMachineAssert(StateMachine<?, ?> actual) {
        super(actual, StateMachineAssert.class);
    }

    public StateMachineAssert hasStateId(Object id) {
        this.isNotNull();
        if (((StateMachine)this.actual).getState() == null) {
            this.failWithMessage("Expected machine's state to be not null", new Object[0]);
        }
        if (!Objects.deepEquals(((StateMachine)this.actual).getState().getId(), id)) {
            this.failWithMessage("Expected machine's state id to be <%s> but was <%s>", new Object[]{id, ((StateMachine)this.actual).getState().getId()});
        }
        return this;
    }

    public StateMachineAssert doesNotHaveState() {
        this.isNotNull();
        if (((StateMachine)this.actual).getState() != null) {
            this.failWithMessage("Expected machine's state to be null but was <%s>", new Object[]{((StateMachine)this.actual).getState()});
        }
        return this;
    }
}

