/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.webflow.context.portlet.FlowUrlHandler;

public class DefaultFlowUrlHandler
implements FlowUrlHandler {
    private static final String EXECUTION_ATTRIBUTE = "execution";

    @Override
    public String getFlowExecutionKey(PortletRequest request) {
        String flowExecutionKey = request.getParameter(EXECUTION_ATTRIBUTE);
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            if (flowExecutionKey == null && request instanceof RenderRequest) {
                flowExecutionKey = (String)session.getAttribute(EXECUTION_ATTRIBUTE);
            } else if (flowExecutionKey != null && request instanceof ActionRequest) {
                session.removeAttribute(EXECUTION_ATTRIBUTE);
            }
        }
        return flowExecutionKey;
    }

    @Override
    public void setFlowExecutionRenderParameter(String flowExecutionKey, ActionResponse response) {
        response.setRenderParameter(EXECUTION_ATTRIBUTE, flowExecutionKey);
    }

    @Override
    public void setFlowExecutionInSession(String flowExecutionKey, RenderRequest request) {
        this.setSessionAttribute(EXECUTION_ATTRIBUTE, flowExecutionKey, (PortletRequest)request);
    }

    @Override
    public void setFlowExecutionInSession(String flowExecutionKey, ResourceRequest request) {
        this.setSessionAttribute(EXECUTION_ATTRIBUTE, flowExecutionKey, (PortletRequest)request);
    }

    @Override
    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, RenderResponse response) {
        return this.createFlowExecutionActionUrl(flowExecutionKey, (MimeResponse)response);
    }

    @Override
    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, ResourceResponse response) {
        return this.createFlowExecutionActionUrl(flowExecutionKey, (MimeResponse)response);
    }

    private void setSessionAttribute(String name, String value, PortletRequest request) {
        PortletSession session = request.getPortletSession();
        session.setAttribute(name, (Object)value);
    }

    private String createFlowExecutionActionUrl(String flowExecutionKey, MimeResponse response) {
        PortletURL url = response.createActionURL();
        url.setParameter(EXECUTION_ATTRIBUTE, flowExecutionKey);
        return url.toString();
    }
}

