/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;

public class MagicScriptDebugContext
extends MagicScriptContext {
    private String id = UUID.randomUUID().toString().replace("-", "");
    private static final Map<String, MagicScriptDebugContext> contextMap = new ConcurrentHashMap<String, MagicScriptDebugContext>();
    public List<Integer> breakpoints;
    private final BlockingQueue<String> producer = new LinkedBlockingQueue<String>();
    private final BlockingQueue<String> consumer = new LinkedBlockingQueue<String>();
    private Consumer<Map<String, Object>> callback;
    private Span.Line line;
    private int timeout = 60;
    private boolean stepInto = false;
    private Scope scope;

    public MagicScriptDebugContext(List<Integer> breakpoints) {
        this.breakpoints = breakpoints;
    }

    public void setCallback(Consumer<Map<String, Object>> callback) {
        this.callback = callback;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        contextMap.put(this.id, this);
        contextMap.remove(oldId);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<Integer> getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(List<Integer> breakpoints) {
        this.breakpoints = breakpoints;
    }

    public synchronized String pause(Span.Line line, Scope scope) throws InterruptedException {
        this.scope = scope;
        this.line = line;
        this.consumer.offer(this.id);
        this.callback.accept(this.getDebugInfo());
        return this.producer.poll(this.timeout, TimeUnit.SECONDS);
    }

    public void await() throws InterruptedException {
        this.consumer.take();
    }

    public void singal() throws InterruptedException {
        this.producer.offer(this.id);
        this.await();
    }

    public boolean isStepInto() {
        return this.stepInto;
    }

    public void setStepInto(boolean stepInto) {
        this.stepInto = stepInto;
    }

    public Map<String, Object> getDebugInfo() {
        ArrayList varList = new ArrayList();
        Set<Map.Entry<String, Object>> entries = this.scope.getVariables().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value = entry.getValue();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.put("name", entry.getKey());
            if (value != null) {
                variable.put("value", this.getValue(value));
                variable.put("type", value.getClass());
            } else {
                variable.put("value", "null");
            }
            varList.add(variable);
        }
        varList.sort((o1, o2) -> {
            Object k1 = o1.get("name");
            Object k2 = o2.get("name");
            if (k1 == null) {
                return -1;
            }
            if (k2 == null) {
                return 1;
            }
            return k1.toString().compareTo(k2.toString());
        });
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("variables", varList);
        info.put("range", Arrays.asList(this.line.getLineNumber(), this.line.getStartCol(), this.line.getEndLineNumber(), this.line.getEndCol()));
        return info;
    }

    public Span.Line getLine() {
        return this.line;
    }

    public String getId() {
        return this.id;
    }

    public static MagicScriptDebugContext getDebugContext(String id) {
        return contextMap.get(id);
    }

    private Object getValue(Object object) {
        try {
            return object.toString();
        }
        catch (Exception ex) {
            if (object instanceof Cloneable) {
                try {
                    return object.getClass().getMethod("clone", new Class[0]).invoke(object, new Object[0]).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "can't get value";
        }
    }
}

