/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ssssssss.script.annotation.Comment;

public class ScriptClass {
    private String className;
    private Set<ScriptMethod> methods = new HashSet<ScriptMethod>();
    private List<ScriptAttribute> attributes = new ArrayList<ScriptAttribute>();
    private String superClass;
    private List<String> interfaces = new ArrayList<String>();
    private Object[] enums;

    public Object[] getEnums() {
        return this.enums;
    }

    public void setEnums(Object[] enums) {
        this.enums = enums;
    }

    public void addAttribute(ScriptAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void addMethod(ScriptMethod method) {
        this.methods.add(method);
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Set<ScriptMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(Set<ScriptMethod> methods) {
        this.methods = methods;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public List<ScriptAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ScriptAttribute> attributes) {
        this.attributes = attributes;
    }

    public static class ScriptMethodParameter {
        private String name;
        private String type;
        private boolean varArgs;
        private String comment;

        public ScriptMethodParameter(Parameter parameter) {
            this.name = parameter.getName();
            Class<?> type = parameter.getType();
            this.varArgs = parameter.isVarArgs();
            Comment parameterComment = parameter.getAnnotation(Comment.class);
            this.comment = parameterComment == null ? null : parameterComment.value();
            this.type = type.isArray() ? type.getSimpleName() : type.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptMethodParameter that = (ScriptMethodParameter)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }

    public static class ScriptMethod {
        private String name;
        private String returnType;
        private String comment;
        private boolean origin;
        private List<ScriptMethodParameter> parameters = new ArrayList<ScriptMethodParameter>();

        public ScriptMethod(Method method) {
            this.name = method.getName();
            Comment methodComment = method.getAnnotation(Comment.class);
            this.comment = methodComment == null ? null : methodComment.value();
            this.origin = methodComment != null && methodComment.origin();
            Class<?> returnType = method.getReturnType();
            this.returnType = returnType.isArray() ? returnType.getSimpleName() : returnType.getName();
            Parameter[] parameters = method.getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.parameters.add(new ScriptMethodParameter(parameters[i]));
                }
            }
        }

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOrigin() {
            return this.origin;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public List<ScriptMethodParameter> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptMethod that = (ScriptMethod)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.parameters);
        }
    }

    public static class ScriptAttribute {
        private String type;
        private String name;

        public ScriptAttribute(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

