/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.functions.linq;

import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.BinaryOperator;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.annotation.Function;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.parsing.ast.BinaryOperation;

public class AggregationFunctions {
    @Function
    @Comment(value="\u805a\u5408\u51fd\u6570-count")
    public int count(Object target) {
        if (target == null) {
            return 0;
        }
        if (target instanceof Map) {
            return 1;
        }
        try {
            return StreamExtension.arrayLikeToList(target).size();
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Function
    @Comment(value="\u805a\u5408\u51fd\u6570-max")
    public Object max(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return target;
        }
        try {
            return StreamExtension.arrayLikeToList(target).stream().reduce(BinaryOperator.maxBy(BinaryOperation::compare)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Function
    @Comment(value="\u805a\u5408\u51fd\u6570-sum")
    public Number sum(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return null;
        }
        try {
            OptionalDouble value = StreamExtension.arrayLikeToList(target).stream().mapToDouble(v -> ObjectConvertExtension.asDouble(v, Double.NaN)).filter(v -> !Double.isNaN(v)).reduce(Double::sum);
            return value.isPresent() ? Double.valueOf(value.getAsDouble()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Function
    @Comment(value="\u805a\u5408\u51fd\u6570-min")
    public Object min(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return target;
        }
        try {
            return StreamExtension.arrayLikeToList(target).stream().reduce(BinaryOperator.minBy(BinaryOperation::compare)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Function
    @Comment(value="\u805a\u5408\u51fd\u6570-avg")
    public Object avg(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return target;
        }
        try {
            OptionalDouble average = StreamExtension.arrayLikeToList(target).stream().mapToDouble(v -> ObjectConvertExtension.asDouble(v, Double.NaN)).filter(v -> !Double.isNaN(v)).average();
            return average.isPresent() ? Double.valueOf(average.getAsDouble()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Function
    @Comment(value="\u5206\u7ec4\u540e\u6309\u6307\u5b9a\u5b57\u7b26\u4e32\u62fc\u63a5")
    public String group_concat(@Comment(value="\u5217\uff0c\u5982t.a") Object target, @Comment(value="\u5206\u9694\u7b26\uff0c\u5982`|`") String separator) {
        if (target == null) {
            return null;
        }
        return StreamExtension.join(target, separator);
    }

    @Function
    @Comment(value="\u5206\u7ec4\u540e\u4f7f\u7528`,`\u62fc\u63a5")
    public String group_concat(@Comment(value="\u5217\uff0c\u5982t.a") Object target) {
        return this.group_concat(target, ",");
    }
}

