/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.VarNode;

public class Scope {
    private Scope parent;
    private VarNode[] variables;
    private static ThreadLocal<Scope> TEMP_SCOPE = new InheritableThreadLocal<Scope>();

    public static void setTempScope(Scope scope) {
        TEMP_SCOPE.set(scope);
    }

    public static void removeTempScope() {
        TEMP_SCOPE.remove();
    }

    public static Scope getTempScope() {
        return TEMP_SCOPE.get();
    }

    public Scope(Scope parent, int count) {
        this.parent = parent;
        this.variables = new VarNode[count];
    }

    public Scope(Map<String, Object> variables) {
        this.variables = variables != null && !variables.isEmpty() ? (VarNode[])variables.entrySet().stream().map(entry -> new VarNode((String)entry.getKey(), entry.getValue(), false)).toArray(VarNode[]::new) : new VarNode[0];
    }

    public Scope(int count) {
        this(null, count);
    }

    public Object getValue(String name) {
        VarNode varNode = this.getVarNode(name);
        return varNode == null ? null : varNode.getValue();
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        Stack<VarNode> stack = new Stack<VarNode>();
        Scope scope = this;
        do {
            for (VarNode node : scope.variables) {
                if (node == null) continue;
                stack.push(node);
            }
        } while ((scope = scope.parent) != null);
        while (!stack.isEmpty()) {
            VarNode node = (VarNode)stack.pop();
            vars.put(node.getName(), node.getValue());
        }
        return vars;
    }

    private VarNode getVarNode(String name) {
        for (int index = this.variables.length - 1; index >= 0; --index) {
            VarNode node = this.variables[index];
            if (node == null || !node.getName().equals(name)) continue;
            return node;
        }
        return this.parent != null ? this.parent.getVarNode(name) : null;
    }

    public Object getValue(VarIndex varIndex) {
        return this.getVarNode(varIndex).getValue();
    }

    private VarNode getVarNode(VarIndex varIndex) {
        VarNode varNode = this.variables[varIndex.getIndex()];
        if (varNode == null) {
            if (this.parent != null) {
                varNode = this.parent.getVarNode(varIndex.getName());
            }
            if (varNode == null) {
                varNode = new VarNode(varIndex.getName(), varIndex.isReference());
            } else if (!varIndex.isReference()) {
                varNode = varNode.copy();
            }
            this.variables[varIndex.getIndex()] = varNode;
        }
        return varNode;
    }

    public Object setValue(VarIndex varIndex, Object value) {
        this.getVarNode(varIndex).setValue(value);
        return value;
    }

    public int find(VarIndex varIndex) {
        for (int index = this.variables.length; index >= 0; --index) {
            VarNode varNode = this.getVarNode(varIndex);
            if (!varIndex.getName().equals(varNode.getName())) continue;
            return index;
        }
        return -1;
    }

    public Scope create(int count) {
        return new Scope(this, count);
    }
}

