/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

public class Span {
    private final String source;
    private final String cachedText;
    private int start;
    private int end;
    private Line line;

    public Span(String source) {
        this(source, 0, source.length());
    }

    public Span(String source, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Start must be <= end.");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Start must be >= 0.");
        }
        if (end > source.length()) {
            throw new IndexOutOfBoundsException("End outside of string.");
        }
        this.source = source;
        this.start = start;
        this.end = end;
        this.cachedText = source.substring(start, end);
    }

    public Span(Span start, Span end) {
        if (!start.source.equals(end.source)) {
            throw new IllegalArgumentException("The two spans do not reference the same source.");
        }
        if (start.start > end.end) {
            throw new IllegalArgumentException("Start must be <= end.");
        }
        if (start.start < 0) {
            throw new IndexOutOfBoundsException("Start must be >= 0.");
        }
        if (start.start > start.source.length() - 1) {
            throw new IndexOutOfBoundsException("Start outside of string.");
        }
        if (end.end > start.source.length()) {
            throw new IndexOutOfBoundsException("End outside of string.");
        }
        this.source = start.source;
        this.start = start.start;
        this.end = end.end;
        this.cachedText = this.source.substring(this.start, this.end);
    }

    public String getText() {
        return this.cachedText;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "Span [text=" + this.getText() + ", start=" + this.start + ", end=" + this.end + "]";
    }

    public Line getLine() {
        int idx;
        char c;
        int lineEnd;
        int lineStart;
        if (this.line != null) {
            return this.line;
        }
        for (lineStart = this.start; lineStart < this.end && lineStart >= 0; --lineStart) {
            char c2 = this.source.charAt(lineStart);
            if (c2 != '\n') continue;
            ++lineStart;
            break;
        }
        if (lineStart < 0) {
            lineStart = 0;
        }
        for (lineEnd = this.end; lineEnd <= this.source.length() - 1 && (c = this.source.charAt(lineEnd)) != '\n'; ++lineEnd) {
        }
        int lineNumber = 0;
        for (idx = lineStart; idx > 0 && idx < this.end; --idx) {
            char c3 = this.source.charAt(idx);
            if (c3 != '\n') continue;
            ++lineNumber;
        }
        int endLineNumber = ++lineNumber;
        for (idx = lineStart + 1; idx < lineEnd; ++idx) {
            char c4 = this.source.charAt(idx);
            if (c4 != '\n') continue;
            ++endLineNumber;
        }
        int startCol = this.start - lineStart + 1;
        int endCol = startCol + this.end - this.start - 1;
        this.line = new Line(this.source, lineStart, lineEnd, lineNumber, endLineNumber, startCol, endCol);
        return this.line;
    }

    public static class Line {
        private final String source;
        private final int start;
        private final int end;
        private final int lineNumber;
        private final int endLineNumber;
        private final int startCol;
        private final int endCol;

        public Line(String source, int start, int end, int lineNumber, int endLineNumber, int startCol, int endCol) {
            this.source = source;
            this.start = start;
            this.end = end;
            this.lineNumber = lineNumber;
            this.endLineNumber = endLineNumber;
            this.startCol = startCol;
            this.endCol = endCol;
        }

        public int getStartCol() {
            return this.startCol;
        }

        public int getEndCol() {
            return this.endCol;
        }

        public String getSource() {
            return this.source;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.source.substring(this.start, this.end);
        }
    }
}

