/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast;

import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class TernaryOperation
extends Expression {
    private final Expression condition;
    private final Expression trueExpression;
    private final Expression falseExpression;

    public TernaryOperation(Expression condition, Expression trueExpression, Expression falseExpression) {
        super(new Span(condition.getSpan(), falseExpression.getSpan()));
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueExpression() {
        return this.trueExpression;
    }

    public Expression getFalseExpression() {
        return this.falseExpression;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object condition = this.getCondition().evaluate(context, scope);
        return BooleanLiteral.isTrue(condition) ? this.getTrueExpression().evaluate(context, scope) : this.getFalseExpression().evaluate(context, scope);
    }
}

