/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.binary;

import java.math.BigDecimal;
import java.util.Objects;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.Expression;

public class AddOperation
extends BinaryOperation {
    public AddOperation(Expression leftOperand, Span span, Expression rightOperand) {
        super(leftOperand, span, rightOperand);
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object value;
        Object left = this.getLeftOperand().evaluate(context, scope);
        Object right = this.getRightOperand().evaluate(context, scope);
        if (left instanceof String || right instanceof String) {
            return left + Objects.toString(right);
        }
        if (right == null) {
            MagicScriptError.error(this.getRightOperand().getSpan().getText() + " \u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c[+]\u64cd\u4f5c", this.getRightOperand().getSpan());
        }
        if (left == null) {
            MagicScriptError.error(this.getLeftOperand().getSpan().getText() + " \u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c[+]\u64cd\u4f5c", this.getLeftOperand().getSpan());
        }
        if ((value = AddOperation.add(left, right)) == null) {
            MagicScriptError.error("[+]\u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u662fString\u6216\u6570\u503c\u7c7b\u578b, \u83b7\u5f97\u7684\u503c\u4e3a\uff1a " + left + ", " + right, this.getSpan());
        }
        return value;
    }

    public static Object add(Object left, Object right) {
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return ObjectConvertExtension.asDecimal(left).add(ObjectConvertExtension.asDecimal(right));
        }
        if (left instanceof Double || right instanceof Double) {
            return ((Number)left).doubleValue() + ((Number)right).doubleValue();
        }
        if (left instanceof Float || right instanceof Float) {
            return Float.valueOf(((Number)left).floatValue() + ((Number)right).floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return ((Number)left).longValue() + ((Number)right).longValue();
        }
        if (left instanceof Integer || right instanceof Integer) {
            return ((Number)left).intValue() + ((Number)right).intValue();
        }
        if (left instanceof Short || right instanceof Short) {
            return ((Number)left).shortValue() + ((Number)right).shortValue();
        }
        if (left instanceof Byte || right instanceof Byte) {
            return ((Number)left).byteValue() + ((Number)right).byteValue();
        }
        return null;
    }
}

