/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.linq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.linq.LinqField;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class LinqJoin
extends Expression {
    private final LinqField target;
    private final Expression condition;
    private final boolean leftJoin;
    private List<Object> cachedValue;

    public LinqJoin(Span span, boolean leftJoin, LinqField target, Expression condition) {
        super(span);
        this.leftJoin = leftJoin;
        this.target = target;
        this.condition = condition;
    }

    public boolean isLeftJoin() {
        return this.leftJoin;
    }

    public LinqField getTarget() {
        return this.target;
    }

    public void setCachedValue(List<Object> cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public List<Object> evaluate(MagicScriptContext context, Scope scope) {
        ArrayList<Object> result = this.leftJoin ? new ArrayList<Object>() : null;
        for (Object object : this.cachedValue) {
            this.target.setValue(context, scope, object);
            if (!BooleanLiteral.isTrue(this.condition.evaluate(context, scope))) continue;
            if (this.isLeftJoin()) {
                result.add(object);
                continue;
            }
            result = Collections.singletonList(object);
            this.target.setValue(context, scope, result);
            return result;
        }
        ArrayList<Object> value = this.isLeftJoin() ? result : Collections.emptyList();
        this.target.setValue(context, scope, value);
        return value;
    }
}

