/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.statement.Spread;

public class ListLiteral
extends Literal {
    public final List<Expression> values;

    public ListLiteral(Span span, List<Expression> values) {
        super(span);
        this.values = values;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        ArrayList<Object> list = new ArrayList<Object>();
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.values.get(i);
            if (expression instanceof Spread) {
                Spread spread = (Spread)expression;
                Object res = spread.getTarget().evaluate(context, scope);
                if (res == null) continue;
                if (res instanceof Collection) {
                    list.addAll((Collection)res);
                    continue;
                }
                if (res instanceof Map) {
                    MagicScriptError.error("\u4e0d\u80fd\u5728list\u4e2d\u5c55\u5f00map", spread.getSpan());
                    continue;
                }
                MagicScriptError.error("\u4e0d\u80fd\u5c55\u5f00\u7684\u7c7b\u578b", spread.getSpan());
                continue;
            }
            list.add(expression.evaluate(context, scope));
        }
        return list;
    }
}

