/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenType;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.literal.StringLiteral;
import org.ssssssss.script.parsing.ast.statement.Spread;

public class MapLiteral
extends Literal {
    private final List<Token> keys;
    private final List<Expression> values;

    public MapLiteral(Span span, List<Token> keys, List<Expression> values) {
        super(span);
        this.keys = keys;
        this.values = values;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int n = this.keys.size();
        for (int i = 0; i < n; ++i) {
            Token tokenKey = this.keys.get(i);
            String key = tokenKey.getSpan().getText();
            if (tokenKey.getType() == TokenType.StringLiteral) {
                key = (String)new StringLiteral(tokenKey.getSpan()).evaluate(context, scope);
            } else if (key != null && key.startsWith("$") && !(key = key.substring(1)).startsWith("$")) {
                Object objKey = context.get(key);
                if (objKey != null) {
                    key = objKey.toString();
                } else {
                    MagicScriptError.error("map\u7684key\u503c\u4e0d\u80fd\u4e3a\u7a7a", tokenKey.getSpan());
                }
            }
            Expression expression = this.values.get(i);
            if (expression instanceof Spread) {
                Spread spread = (Spread)expression;
                Object res = spread.getTarget().evaluate(context, scope);
                if (res == null) continue;
                if (res instanceof Map) {
                    map.putAll((Map)res);
                    continue;
                }
                if (res instanceof Collection) {
                    int index = 0;
                    for (Object obj : (Collection)res) {
                        map.put(String.valueOf(index++), obj);
                    }
                    continue;
                }
                MagicScriptError.error("\u4e0d\u80fd\u5c55\u5f00\u7684\u7c7b\u578b", spread.getSpan());
                continue;
            }
            map.put(key, expression.evaluate(context, scope));
        }
        return map;
    }
}

