/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.CharacterStream;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Literal;

public class StringLiteral
extends Literal {
    private final String value;

    public StringLiteral(Span literal) {
        super(literal);
        String unescapedValue = this.getSpan().getText();
        StringBuilder builder = new StringBuilder();
        CharacterStream stream = new CharacterStream(unescapedValue);
        while (stream.hasMore()) {
            if (stream.match("\\\\", true)) {
                builder.append('\\');
                continue;
            }
            if (stream.match("\\n", true)) {
                builder.append('\n');
                continue;
            }
            if (stream.match("\\r", true)) {
                builder.append('\r');
                continue;
            }
            if (stream.match("\\t", true)) {
                builder.append('\t');
                continue;
            }
            if (stream.match("\\\"", true)) {
                builder.append('\"');
                continue;
            }
            if (stream.match("\\'", true)) {
                builder.append("'");
                continue;
            }
            builder.append(stream.consume());
        }
        this.value = builder.toString();
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }
}

