/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.statement.LambdaFunction;

public class AsyncCall
extends Expression {
    private final Expression expression;
    private static final int size = Runtime.getRuntime().availableProcessors() * 2;
    private static ThreadPoolExecutor threadPoolExecutor = AsyncCall.setThreadPoolExecutorSize(size);

    public AsyncCall(Span span, Expression expression) {
        super(span);
        this.expression = expression;
    }

    public static ThreadPoolExecutor setThreadPoolExecutorSize(int size) {
        if (size > 0) {
            threadPoolExecutor = new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(size * 2), new AsyncThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return threadPoolExecutor;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object[] args = null;
        if (this.expression instanceof LambdaFunction) {
            LambdaFunction lambdaFunction = (LambdaFunction)this.expression;
            List<VarIndex> parameters = lambdaFunction.getParameters();
            scope = scope.create(lambdaFunction.getVarCount());
            args = new Object[parameters.size()];
            for (int i = 0; i < args.length; ++i) {
                VarIndex varIndex = parameters.get(i);
                args[i] = scope.getValue(varIndex);
            }
        }
        Object[] finalArgs = args;
        Scope finalScope = scope;
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> {
            try {
                MagicScriptContext.set(context);
                context.setVarScope(finalScope);
                if (this.expression instanceof LambdaFunction) {
                    Object object = ((LambdaFunction)this.expression).evaluate(context, finalScope, finalArgs);
                    return object;
                }
                Object object = this.expression.evaluate(context, finalScope);
                return object;
            }
            finally {
                context.removeVarScope();
                MagicScriptContext.remove();
            }
        });
        if (Thread.currentThread().getThreadGroup() == AsyncThreadFactory.ASYNC_THREAD_GROUP) {
            futureTask.run();
        } else {
            threadPoolExecutor.submit(futureTask);
        }
        return futureTask;
    }

    static class AsyncThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final ThreadGroup ASYNC_THREAD_GROUP = new ThreadGroup("magic-async-group");
        private final String namePrefix = "magic-async-";

        AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(ASYNC_THREAD_GROUP, r, "magic-async-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

