/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.interpreter.AstInterpreter;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Break;
import org.ssssssss.script.parsing.ast.statement.Return;

public class ForStatement
extends Node {
    private final VarIndex indexOrKey;
    private final VarIndex value;
    private final Expression mapOrArray;
    private final List<Node> body;
    private final int varCount;

    public ForStatement(Span span, VarIndex indexOrKey, VarIndex value, int varCount, Expression mapOrArray, List<Node> body) {
        super(span);
        this.indexOrKey = indexOrKey;
        this.value = value;
        this.mapOrArray = mapOrArray;
        this.body = body;
        this.varCount = varCount;
    }

    public Expression getMapOrArray() {
        return this.mapOrArray;
    }

    public List<Node> getBody() {
        return this.body;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        scope = scope.create(this.varCount);
        Object mapOrArray = this.getMapOrArray().evaluate(context, scope);
        if (mapOrArray == null) {
            MagicScriptError.error("Expected a map or array, got null.", this.getMapOrArray().getSpan());
        }
        if (mapOrArray instanceof Map) {
            Map map = (Map)mapOrArray;
            if (this.indexOrKey != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry e = entry = iterator.next();
                    scope.setValue(this.indexOrKey, e.getKey());
                    scope.setValue(this.value, e.getValue());
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            } else {
                for (Object value : map.values()) {
                    scope.setValue(this.value, value);
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            }
        } else if (mapOrArray instanceof Iterable) {
            if (this.indexOrKey != null) {
                Iterator iter = ((Iterable)mapOrArray).iterator();
                int i = 0;
                while (iter.hasNext()) {
                    scope.setValue(this.indexOrKey, i++);
                    scope.setValue(this.value, iter.next());
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            } else {
                Iterator iter = ((Iterable)mapOrArray).iterator();
                while (iter.hasNext()) {
                    scope.setValue(this.value, iter.next());
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            }
        } else if (mapOrArray instanceof Iterator) {
            if (this.indexOrKey != null) {
                MagicScriptError.error("Can not do indexed/keyed for loop on an iterator.", this.getMapOrArray().getSpan());
            } else {
                Iterator iter = (Iterator)mapOrArray;
                while (iter.hasNext()) {
                    scope.setValue(this.value, iter.next());
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            }
        } else if (mapOrArray != null && mapOrArray.getClass().isArray()) {
            int len = Array.getLength(mapOrArray);
            if (this.indexOrKey != null) {
                for (int i = 0; i < len; ++i) {
                    scope.setValue(this.indexOrKey, i);
                    scope.setValue(this.value, Array.get(mapOrArray, i));
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    scope.setValue(this.value, Array.get(mapOrArray, i));
                    Object breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.getBody(), context, scope);
                    if (breakOrContinueOrReturn != Break.BREAK_SENTINEL) {
                        if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
                        return breakOrContinueOrReturn;
                    }
                    break;
                }
            }
        } else {
            MagicScriptError.error("Expected a map, an array or an iterable, got " + mapOrArray, this.getMapOrArray().getSpan());
        }
        return null;
    }
}

