/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Spread;
import org.ssssssss.script.reflection.JavaInvoker;
import org.ssssssss.script.reflection.JavaReflection;

public class FunctionCall
extends Expression {
    private final Expression function;
    private final List<Expression> arguments;
    private JavaInvoker<Method> cachedFunction;
    private final ThreadLocal<Object[]> cachedArguments;
    private final boolean inLinq;

    public FunctionCall(Span span, Expression function, List<Expression> arguments, boolean inLinq) {
        super(span);
        this.function = function;
        this.arguments = arguments;
        this.cachedArguments = new InheritableThreadLocal<Object[]>();
        this.inLinq = inLinq;
    }

    public Expression getFunction() {
        return this.function;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public JavaInvoker<Method> getCachedFunction() {
        return this.cachedFunction;
    }

    public void setCachedFunction(JavaInvoker<Method> cachedFunction) {
        this.cachedFunction = cachedFunction;
    }

    public Object[] getCachedArguments() {
        Object[] args = this.cachedArguments.get();
        if (args == null) {
            args = new Object[this.arguments.size()];
            this.cachedArguments.set(args);
        }
        return args;
    }

    public void clearCachedArguments() {
        Object[] args = this.getCachedArguments();
        for (int i = 0; i < args.length; ++i) {
            args[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        try {
            Object expr;
            Object[] argumentValues = this.getCachedArguments();
            List<Expression> arguments = this.getArguments();
            int n = argumentValues.length;
            int pIndex2 = 0;
            for (int i = 0; i < n; ++i) {
                expr = arguments.get(i);
                if (expr instanceof Spread) {
                    Object[] spreadValues = ((Spread)expr).doSpread(context, scope, this.inLinq);
                    int spreadLength = spreadValues.length;
                    if (spreadLength <= 0) continue;
                    Object[] valTemp = argumentValues;
                    argumentValues = new Object[argumentValues.length + spreadLength - 1];
                    System.arraycopy(valTemp, 0, argumentValues, 0, valTemp.length);
                    System.arraycopy(spreadValues, 0, argumentValues, pIndex2, spreadLength);
                    pIndex2 += spreadLength;
                    continue;
                }
                argumentValues[pIndex2++] = ((Node)expr).evaluate(context, scope, this.inLinq);
            }
            String functionName = this.getFunction().getSpan().getText();
            Object function = this.getFunction().evaluate(context, scope);
            if (function instanceof Function) {
                Object pIndex2 = ((Function)function).apply(argumentValues);
                return pIndex2;
            }
            if (function instanceof Node) {
                Object pIndex2 = ((Node)function).evaluate(context, scope);
                return pIndex2;
            }
            JavaInvoker<Method> invoker = this.getCachedFunction();
            if (invoker == null) {
                invoker = JavaReflection.getFunction(functionName, argumentValues);
                if (invoker == null) {
                    MagicScriptError.error("\u627e\u4e0d\u5230\u65b9\u6cd5 " + this.getFunction().getSpan().getText() + "(" + String.join((CharSequence)",", JavaReflection.getStringTypes(argumentValues)) + ")", this.getSpan());
                }
                this.setCachedFunction(invoker);
            }
            try {
                expr = invoker.invoke0(function, scope, argumentValues);
                return expr;
            }
            catch (Throwable t) {
                MagicScriptError.error(t.getMessage(), this.getSpan(), t);
                Object var9_15 = null;
                this.clearCachedArguments();
                return var9_15;
            }
        }
        finally {
            this.clearCachedArguments();
        }
    }
}

