/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.interpreter.AstInterpreter;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class IfStatement
extends Node {
    private final Expression condition;
    private final List<Node> trueBlock;
    private final List<IfStatement> elseIfs;
    private final List<Node> falseBlock;
    private final int trueVarCount;
    private final int falseVarCount;

    public IfStatement(Span span, Expression condition, List<Node> trueBlock, List<IfStatement> elseIfs, List<Node> falseBlock, int trueVarCount, int falseVarCount) {
        super(span);
        this.condition = condition;
        this.trueBlock = trueBlock;
        this.elseIfs = elseIfs;
        this.falseBlock = falseBlock;
        this.trueVarCount = trueVarCount;
        this.falseVarCount = falseVarCount;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public List<Node> getTrueBlock() {
        return this.trueBlock;
    }

    public List<IfStatement> getElseIfs() {
        return this.elseIfs;
    }

    public List<Node> getFalseBlock() {
        return this.falseBlock;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object condition = this.getCondition().evaluate(context, scope);
        if (BooleanLiteral.isTrue(condition)) {
            return AstInterpreter.interpretNodeList(this.getTrueBlock(), context, scope.create(this.trueVarCount));
        }
        if (this.getElseIfs().size() > 0) {
            for (IfStatement elseIf : this.getElseIfs()) {
                condition = elseIf.getCondition().evaluate(context, scope);
                if (!BooleanLiteral.isTrue(condition)) continue;
                return AstInterpreter.interpretNodeList(elseIf.getTrueBlock(), context, scope.create(elseIf.trueVarCount));
            }
        }
        if (this.getFalseBlock().size() > 0) {
            return AstInterpreter.interpretNodeList(this.getFalseBlock(), context, scope.create(this.falseVarCount));
        }
        return null;
    }
}

