/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.exception.ExceptionUtils;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.literal.StringLiteral;
import org.ssssssss.script.parsing.ast.statement.MethodCall;
import org.ssssssss.script.reflection.JavaReflection;

public class MemberAccess
extends Expression
implements VariableSetter {
    private final Expression object;
    private final Span name;
    private Field cachedMember;
    private final boolean optional;
    private final boolean whole;

    public MemberAccess(Expression object, boolean optional, Span name, boolean whole) {
        super(name);
        this.object = object;
        this.name = name;
        this.optional = optional;
        this.whole = whole;
    }

    public boolean isWhole() {
        return this.whole;
    }

    public Expression getObject() {
        return this.object;
    }

    public Span getName() {
        return this.name;
    }

    public Field getCachedMember() {
        return this.cachedMember;
    }

    public void setCachedMember(Field cachedMember) {
        this.cachedMember = cachedMember;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        String text;
        Object object = this.getObject().evaluate(context, scope);
        if (object == null) {
            if (this.optional) {
                return null;
            }
            MagicScriptError.error(String.format("\u5bf9\u8c61[%s]\u4e3a\u7a7a", this.getObject().getSpan().getText()), this.getObject().getSpan());
        }
        if (object.getClass().isArray() && "length".equals(this.getName().getText())) {
            return Array.getLength(object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(this.getName().getText());
        }
        if (object instanceof Class && this.getName().getText().equals("class")) {
            return object;
        }
        Field field = this.getCachedMember();
        if (field != null) {
            try {
                return JavaReflection.getFieldValue(object, field);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((field = JavaReflection.getField(object, text = this.getName().getText())) == null) {
            if (object instanceof Collection) {
                if (this.isInLinq()) {
                    return ((Collection)object).stream().map(it -> {
                        if (it instanceof Map) {
                            Map map = (Map)it;
                            return map.get(this.getName().getText());
                        }
                        return null;
                    }).collect(Collectors.toList());
                }
                Map value = ((Collection)object).stream().findFirst().orElse(Collections.emptyMap());
                if (value instanceof Map) {
                    Map map = value;
                    return map.get(this.getName().getText());
                }
            }
            String methodName = text.length() > 1 ? text.substring(0, 1).toUpperCase() + text.substring(1) : text.toUpperCase();
            MemberAccess access = new MemberAccess(this.object, this.optional, new Span("get" + methodName), this.whole);
            MethodCall methodCall = new MethodCall(this.getName(), access, Collections.emptyList());
            try {
                return methodCall.evaluate(context, scope);
            }
            catch (MagicScriptException e) {
                if (ExceptionUtils.indexOfThrowable(e, InvocationTargetException.class) > -1) {
                    MagicScriptError.error(String.format("\u5728%s\u4e2d\u8c03\u7528\u65b9\u6cd5get%s\u53d1\u751f\u5f02\u5e38", object.getClass(), methodName), this.getSpan(), e);
                    return null;
                }
                access = new MemberAccess(this.object, this.optional, new Span("get"), false);
                methodCall = new MethodCall(this.getName(), access, Arrays.asList(new StringLiteral(this.getName())));
                try {
                    return methodCall.evaluate(context, scope);
                }
                catch (MagicScriptException e3) {
                    if (ExceptionUtils.indexOfThrowable(e3, InvocationTargetException.class) > -1) {
                        MagicScriptError.error(String.format("\u5728%s\u4e2d\u8c03\u7528\u65b9\u6cd5get\u53d1\u751f\u5f02\u5e38", object.getClass(), methodName), this.getSpan(), e);
                        return null;
                    }
                    access = new MemberAccess(this.object, this.optional, new Span("is" + methodName), this.whole);
                    methodCall = new MethodCall(this.getName(), access, Collections.emptyList());
                    try {
                        return methodCall.evaluate(context, scope);
                    }
                    catch (MagicScriptException e1) {
                        if (ExceptionUtils.indexOfThrowable(e1, InvocationTargetException.class) > -1) {
                            MagicScriptError.error(String.format("\u5728%s\u4e2d\u8c03\u7528\u65b9\u6cd5is%s\u53d1\u751f\u5f02\u5e38", object.getClass(), methodName), this.getSpan(), e);
                            return null;
                        }
                        Object innerClass = JavaReflection.getInnerClass(object, text);
                        if (innerClass != null) {
                            return innerClass;
                        }
                        MagicScriptError.error(String.format("\u5728%s\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027%s\u6216\u8005\u65b9\u6cd5get%s\u3001\u65b9\u6cd5is%s,\u5185\u90e8\u7c7b%s", object.getClass(), this.getName().getText(), methodName, methodName, text), this.getSpan());
                    }
                }
            }
        }
        this.setCachedMember(field);
        return JavaReflection.getFieldValue(object, field);
    }

    @Override
    public void setValue(MagicScriptContext context, Scope scope, final Object value) {
        Object object = this.getObject().evaluate(context, scope);
        if (object != null) {
            if (object instanceof Map) {
                Map map = (Map)object;
                map.put(this.getName().getText(), value);
            } else {
                Field field = this.getCachedMember();
                if (field != null) {
                    try {
                        JavaReflection.setFieldValue(object, field, value);
                    }
                    catch (Throwable throwable) {}
                } else {
                    String text = this.getName().getText();
                    field = JavaReflection.getField(object, text);
                    if (field == null) {
                        String methodName = text.length() > 1 ? text.substring(0, 1).toUpperCase() + text.substring(1) : text.toUpperCase();
                        MemberAccess access = new MemberAccess(this.object, this.optional, new Span("set" + methodName), this.whole);
                        MethodCall methodCall = new MethodCall(this.getName(), access, Collections.singletonList(new Literal(null){

                            @Override
                            public Object evaluate(MagicScriptContext context, Scope scope) {
                                return value;
                            }
                        }));
                        try {
                            methodCall.evaluate(context, scope);
                        }
                        catch (MagicScriptException e) {
                            if (ExceptionUtils.indexOfThrowable(e, InvocationTargetException.class) > -1) {
                                MagicScriptError.error(String.format("\u5728%s\u4e2d\u8c03\u7528\u65b9\u6cd5get%s\u53d1\u751f\u5f02\u5e38", object.getClass(), methodName), this.getSpan(), e);
                            }
                            MagicScriptError.error(String.format("\u5728%s\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027%s\u6216\u8005\u65b9\u6cd5set%s", object.getClass(), this.getName().getText(), methodName), this.getSpan());
                        }
                    } else {
                        JavaReflection.setFieldValue(object, field, value);
                    }
                }
            }
        }
    }
}

