/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.ssssssss.script.convert.ClassImplicitConvert;
import org.ssssssss.script.parsing.Scope;

public abstract class JavaInvoker<T extends Executable> {
    private final Map<Integer, ClassImplicitConvert> converts = new HashMap<Integer, ClassImplicitConvert>();
    private T executable;
    private Class<?>[] parameterTypes;
    private boolean implicit = false;
    private boolean extension = false;
    private Object defaultTarget;

    JavaInvoker(T executable) {
        this.executable = executable;
        ((AccessibleObject)this.executable).setAccessible(true);
        this.parameterTypes = ((Executable)this.executable).getParameterTypes();
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public Object getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(Object defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public T getExecutable() {
        return this.executable;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean isVarArgs() {
        return ((Executable)this.executable).isVarArgs();
    }

    public Object invoke0(Object target, Scope scope, Object ... arguments) throws Throwable {
        try {
            if (scope != null) {
                Scope.setTempScope(scope);
            }
            if (this.extension) {
                int argumentLength = arguments == null ? 0 : arguments.length;
                Object[] parameters = new Object[argumentLength + 1];
                if (argumentLength > 0) {
                    System.arraycopy(arguments, 0, parameters, 1, argumentLength);
                }
                parameters[0] = target;
                if (target.getClass().isArray()) {
                    Object[] objs = new Object[Array.getLength(target)];
                    int len = objs.length;
                    for (int i = 0; i < len; ++i) {
                        Array.set(objs, i, Array.get(target, i));
                    }
                    parameters[0] = objs;
                }
                arguments = parameters;
            }
            Object argumentLength = this.invoke(target, this.processArguments(arguments));
            return argumentLength;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e1) {
            throw e1;
        }
        finally {
            if (scope != null) {
                Scope.removeTempScope();
            }
        }
    }

    abstract Object invoke(Object var1, Object ... var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;

    protected void addClassImplicitConvert(int index, ClassImplicitConvert classImplicitConvert) {
        this.converts.put(index, classImplicitConvert);
    }

    protected Object[] processArguments(Object[] arguments) {
        if (this.isVarArgs()) {
            int count = ((Executable)this.executable).getParameterCount();
            Object[] args = new Object[count];
            if (arguments != null) {
                for (int i = 0; i < count - 1; ++i) {
                    args[i] = arguments[i];
                }
                if (arguments.length - count + 1 > 0) {
                    int len = arguments.length - count + 1;
                    Object varArgs = Array.newInstance(((Executable)this.executable).getParameterTypes()[count - 1].getComponentType(), len);
                    for (int i = 0; i < len; ++i) {
                        Array.set(varArgs, i, arguments[count - 1 + i]);
                    }
                    args[count - 1] = varArgs;
                }
            }
            arguments = args;
        }
        if (arguments != null) {
            for (Map.Entry<Integer, ClassImplicitConvert> entry : this.converts.entrySet()) {
                int index = entry.getKey();
                arguments[index] = entry.getValue().convert(arguments[index], this.parameterTypes[index]);
            }
        }
        return arguments;
    }
}

