/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.parsing.Parser;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Tokenizer;
import org.ssssssss.script.parsing.ast.Expression;

public class MagicScriptContext {
    private static final ThreadLocal<MagicScriptContext> CONTEXT_THREAD_LOCAL = new InheritableThreadLocal<MagicScriptContext>();
    private final ThreadLocal<Scope> CONTEXT_VAR_SCOPE = new InheritableThreadLocal<Scope>();
    private Map<String, Object> rootVariables = new HashMap<String, Object>();
    private List<String> importPackages = new ArrayList<String>();

    public MagicScriptContext() {
    }

    public MagicScriptContext(Map<String, Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    public static MagicScriptContext get() {
        return CONTEXT_THREAD_LOCAL.get();
    }

    public static void remove() {
        CONTEXT_THREAD_LOCAL.remove();
    }

    public static void set(MagicScriptContext context) {
        CONTEXT_THREAD_LOCAL.set(context);
    }

    public String getString(String name) {
        return Objects.toString(this.get(name), null);
    }

    public void addImport(String packageName) {
        this.importPackages.add(packageName);
    }

    public Class<?> getImportClass(String simpleClassName) {
        for (int i = this.importPackages.size() - 1; i >= 0; --i) {
            try {
                return Class.forName(this.importPackages.get(i) + simpleClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    public Object get(String name) {
        Scope scope = this.CONTEXT_VAR_SCOPE.get();
        if (scope != null) {
            return scope.getValue(name);
        }
        return this.rootVariables.get(name);
    }

    public MagicScriptContext set(String name, Object value) {
        this.rootVariables.put(name, value);
        return this;
    }

    public void setVarScope(Scope scope) {
        this.CONTEXT_VAR_SCOPE.set(scope);
    }

    public void removeVarScope() {
        this.CONTEXT_VAR_SCOPE.remove();
    }

    public Object eval(String script) {
        try {
            Parser parser = new Parser();
            Expression expression = parser.parseExpression(Tokenizer.tokenize(script));
            Scope scope = Scope.getTempScope();
            if (scope == null) {
                scope = this.CONTEXT_VAR_SCOPE.get();
            }
            return expression.evaluate(this, scope.create(parser.getTopVarCount()));
        }
        catch (Exception e) {
            Throwable throwable = MagicScriptError.unwrap(e);
            if (throwable instanceof MagicScriptException) {
                throw new RuntimeException(((MagicScriptException)throwable).getSimpleMessage());
            }
            throw new RuntimeException(throwable);
        }
    }

    public Map<String, Object> getRootVariables() {
        return this.rootVariables;
    }

    public Map<String, Object> getVariables() {
        return this.CONTEXT_VAR_SCOPE.get().getVariables();
    }

    public void putMapIntoContext(Map<String, Object> map) {
        if (map != null && !map.isEmpty()) {
            this.rootVariables.putAll(map);
        }
    }
}

