/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.TokenStream;

public class MagicScriptError {
    public static void error(String message, TokenStream stream) {
        if (stream.hasMore()) {
            MagicScriptError.error(message, stream.consume().getSpan());
        } else {
            MagicScriptError.error(message, stream.getPrev().getSpan());
        }
    }

    public static void error(String message, Span location, Throwable cause) {
        if ((cause = MagicScriptError.unwrap(cause)) instanceof MagicExitException) {
            throw (MagicExitException)cause;
        }
        if (cause instanceof MagicScriptException) {
            MagicScriptException mse = (MagicScriptException)cause;
            if (mse.getLocation() == null) {
                MagicScriptError.error(message, location, cause.getCause());
                return;
            }
            throw mse;
        }
        Span.Line line = location.getLine();
        String errorMessage = message + " at Row:";
        errorMessage = errorMessage + line.getLineNumber() + "~" + line.getEndLineNumber() + ",Col:";
        errorMessage = errorMessage + line.getStartCol() + "~" + line.getEndCol() + "\n\n";
        errorMessage = errorMessage + line.getText();
        errorMessage = errorMessage + "\n";
        int errorStart = location.getStart() - line.getStart();
        int errorEnd = errorStart + location.getText().length() - 1;
        int n = line.getText().length();
        for (int i = 0; i < n; ++i) {
            boolean useTab = line.getText().charAt(i) == '\t';
            errorMessage = errorMessage + (i >= errorStart && i <= errorEnd ? "^" : (useTab ? "\t" : " "));
        }
        if (cause == null) {
            throw new MagicScriptException(errorMessage, message, location);
        }
        throw new MagicScriptException(errorMessage, message, cause, location);
    }

    public static void error(String message, Span location) {
        MagicScriptError.error(message, location, null);
    }

    public static Throwable unwrap(Throwable root) {
        for (Throwable parent = root; parent != null; parent = parent.getCause()) {
            if (!(parent instanceof MagicScriptException)) continue;
            root = parent;
        }
        return root;
    }
}

