/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.functions;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.functions.ObjectTypeConditionExtension;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.parsing.ast.binary.LessOperation;
import org.ssssssss.script.reflection.JavaReflection;

public class MapExtension {
    @Comment(value="Map\u7c7b\u578b\u5bf9\u8c61\u8f6cJavaBean")
    public static Object asBean(Map<?, ?> source, @Comment(value="\u76ee\u6807Class") Class<?> target) {
        Object result = null;
        try {
            result = target.newInstance();
            Set<Map.Entry<?, ?>> entries = source.entrySet();
            for (Map.Entry<?, ?> entry : entries) {
                Object value = entry.getValue();
                String member = Objects.toString(entry.getKey(), null);
                if (value == null || member == null) continue;
                Field field = JavaReflection.getField(target, member);
                MapExtension.setFieldValue(result, field, value);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    @Comment(value="\u5faa\u73afMap", origin=true)
    public Map<?, ?> each(Map<?, ?> source, @Comment(value="\u5faa\u73af\u51fd\u6570\uff0c\u5982:(key,value,source)=>map['xx'] = key;") Function<Object[], Object> function) {
        source.forEach((key, value) -> function.apply(new Object[]{key, value, source}));
        return source;
    }

    @Comment(value="map\u8f6cList")
    public static List<?> asList(Map<?, ?> source, @Comment(value="\u6620\u5c04\u51fd\u6570\uff0c\u5982:(key,value,source)=>{'k' : key,'v' : value}") Function<Object[], Object> mapping) {
        ArrayList result = new ArrayList();
        source.forEach((key, value) -> result.add(mapping.apply(new Object[]{key, value, source})));
        return result;
    }

    @Comment(value="\u5408\u5e76Map")
    public Map<?, ?> merge(Map<Object, Object> source, @Comment(value="key") Object key, @Comment(value="value") Object value) {
        source.put(key, value);
        return source;
    }

    @Comment(value="\u5408\u5e76Map")
    public Map<?, ?> merge(Map<Object, Object> source, Map<Object, Object> ... targets) {
        if (targets != null) {
            int len = targets.length;
            for (int i = 0; i < len; ++i) {
                source.putAll(targets[i]);
            }
        }
        return source;
    }

    @Comment(value="\u5c06Map\u8f6c\u4e3aString")
    public String asString(Map<?, ?> source, @Comment(value="key\u4e0ekey\u4e4b\u95f4\u7684\u8fde\u63a5\u7b26\u5982&") String separator, @Comment(value="key\u4e0evalue\u4e4b\u95f4\u7684\u8fde\u63a5\u7b26\uff0c\u5982=") String join) {
        Set<Map.Entry<?, ?>> entries = source.entrySet();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : entries) {
            builder.append(entry.getKey());
            builder.append(join);
            builder.append(Objects.toString(entry.getValue(), ""));
            builder.append(separator);
        }
        if (entries.size() > 0) {
            return builder.substring(0, builder.length() - separator.length());
        }
        return builder.toString();
    }

    @Comment(value="\u5c06Map\u8f6c\u4e3aString")
    public String asString(Map<?, ?> source, @Comment(value="key\u4e0evalue\u4e4b\u95f4\u7684\u8fde\u63a5\u7b26\uff0c\u5982=") String separator, @Comment(value="\u8f6c\u6362\u65b9\u6cd5\uff0c\u5982\uff1a(key,value)=>key + '=' + value || ''") Function<Object[], Object> mapping) {
        Set<Map.Entry<?, ?>> entries = source.entrySet();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : entries) {
            builder.append(Objects.toString(mapping.apply(new Object[]{entry.getKey(), entry.getValue()}), ""));
            builder.append(separator);
        }
        if (entries.size() > 0) {
            return builder.substring(0, builder.length() - separator.length());
        }
        return builder.toString();
    }

    @Comment(value="\u5bf9Map\u8fdb\u884c\u6392\u5e8f")
    public Map<?, ?> sort(Map<?, ?> source) {
        Set<?> keys = source.keySet();
        LinkedHashMap sortedMap = new LinkedHashMap();
        keys.stream().sorted((o1, o2) -> {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            int value = LessOperation.compare(o1, o2);
            return value == -2 ? 0 : value;
        }).forEach(key -> sortedMap.put(key, source.get(key)));
        return sortedMap;
    }

    @Comment(value="\u5bf9Map\u8fdb\u884c\u6392\u5e8f")
    public Map<?, ?> sort(Map<?, ?> source, @Comment(value="\u6bd4\u8f83\u5668\uff0c\u5982:(k1,k2,v1,v2)=>k1.compareTo(k2);") Function<Object[], Object> comparator) {
        Set<?> keys = source.keySet();
        LinkedHashMap sortedMap = new LinkedHashMap();
        keys.stream().sorted((o1, o2) -> ObjectConvertExtension.asInt(comparator.apply(new Object[]{o1, o2, source.get(o1), source.get(o2)}), 0)).forEach(key -> sortedMap.put(key, source.get(key)));
        return sortedMap;
    }

    @Comment(value="\u5bf9Map\u7684key\u8fdb\u884c\u66ff\u6362")
    public Map<String, Object> replaceKey(Map<String, Object> source, String target, String replacement) {
        return this.replaceKey(source, src -> src[0].toString().replace(target, replacement));
    }

    @Comment(value="\u5bf9Map\u7684key\u8fdb\u884c\u6b63\u5219\u66ff\u6362")
    public Map<String, Object> replaceAllKey(Map<String, Object> source, String regx, String replacement) {
        return this.replaceKey(source, src -> src[0].toString().replaceAll(regx, replacement));
    }

    @Comment(value="\u5bf9Map\u7684key\u8fdb\u884c\u66ff\u6362")
    public Map<String, Object> replaceKey(Map<String, Object> source, Function<Object[], String> functional) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = source.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            result.put(functional.apply(new Object[]{entry.getKey()}), entry.getValue());
        }
        return result;
    }

    private static void setFieldValue(Object object, Field field, Object value) {
        if (field != null) {
            try {
                if (ObjectTypeConditionExtension.isCollection(field.getType())) {
                    Type genericType = field.getGenericType();
                    if (genericType instanceof ParameterizedType) {
                        Class type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        JavaReflection.setFieldValue(object, field, StreamExtension.asBean(value, type));
                    }
                } else if (field.getType().isArray()) {
                    JavaReflection.setFieldValue(object, field, StreamExtension.asBean(value, field.getType().getComponentType(), true));
                } else if (JavaReflection.isPrimitiveAssignableFrom(value.getClass(), field.getType()) || field.getType().isAssignableFrom(value.getClass())) {
                    JavaReflection.setFieldValue(object, field, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

