/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.ssssssss.script.annotation.Comment;

public class NumberExtension {
    @Comment(value="\u56db\u820d\u4e94\u5165\u4fdd\u7559N\u4f4d\u5c0f\u6570")
    public static double round(Number number, @Comment(value="\u89c4\u5b9a\u5c0f\u6570\u7684\u4f4d\u6570") int num) {
        return new BigDecimal("" + number.doubleValue()).setScale(num, RoundingMode.HALF_UP).doubleValue();
    }

    @Comment(value="\u56db\u820d\u4e94\u5165\u4fdd\u7559N\u4f4d\u5c0f\u6570,\u4effJS\u7684toFixed")
    public String toFixed(Number number, @Comment(value="\u89c4\u5b9a\u5c0f\u6570\u7684\u4f4d\u6570") int num) {
        return new BigDecimal("" + number.doubleValue()).setScale(num, RoundingMode.HALF_UP).toString();
    }

    @Comment(value="\u5411\u4e0b\u53d6\u6574")
    public static Number floor(Number number) {
        if (number instanceof Double || number instanceof Float) {
            return NumberExtension.fixed(Math.floor(number.floatValue()));
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).setScale(0, RoundingMode.FLOOR);
        }
        return number;
    }

    @Comment(value="\u5411\u4e0a\u53d6\u6574")
    public static Number ceil(Number number) {
        if (number instanceof Double || number instanceof Float) {
            return NumberExtension.fixed(Math.ceil(number.doubleValue()));
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).setScale(0, RoundingMode.UP);
        }
        return number;
    }

    @Comment(value="\u8f6c\u4e3a\u767e\u5206\u6bd4")
    public static String asPercent(Number number, @Comment(value="\u89c4\u5b9a\u5c0f\u6570\u7684\u4f4d\u6570") int num) {
        return new BigDecimal(number.doubleValue() * 100.0).setScale(num, RoundingMode.HALF_UP).toString() + "%";
    }

    private static Number fixed(double value) {
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            return (long)value;
        }
        return value;
    }
}

