/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.interpreter;

import java.util.List;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptDebugContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.exception.DebugTimeoutException;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Break;
import org.ssssssss.script.parsing.ast.statement.Continue;
import org.ssssssss.script.parsing.ast.statement.Return;
import org.ssssssss.script.runtime.ExitValue;

public class AstInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object interpret(MagicScript magicScript, MagicScriptContext context, Scope scope) {
        try {
            MagicScriptContext.set(context);
            context.setVarScope(scope);
            Object value = AstInterpreter.interpretNodeList(magicScript.getNodes(), context, scope);
            if (value instanceof Return.ReturnValue) {
                Object object = ((Return.ReturnValue)value).getValue();
                return object;
            }
            Object var4_7 = null;
            return var4_7;
        }
        catch (MagicExitException mee) {
            ExitValue exitValue = mee.getExitValue();
            return exitValue;
        }
        catch (Throwable t) {
            MagicScriptError.error("\u6267\u884c\u811a\u672c\u51fa\u9519 " + t.getMessage(), magicScript.getNodes().get(0).getSpan(), t);
        }
        finally {
            context.removeVarScope();
            MagicScriptContext.remove();
        }
        return null;
    }

    public static Object interpretNodeList(List<Node> nodes, MagicScriptContext context, Scope scope) {
        if (nodes != null) {
            boolean step = false;
            for (Node node : nodes) {
                if (context instanceof MagicScriptDebugContext) {
                    MagicScriptDebugContext debugContext = (MagicScriptDebugContext)context;
                    Span.Line line = node.getSpan().getLine();
                    if (step || debugContext.getBreakpoints().contains(line.getLineNumber())) {
                        try {
                            if (debugContext.pause(line, scope) == null) {
                                throw new DebugTimeoutException();
                            }
                            step = debugContext.isStepInto();
                            debugContext.setStepInto(false);
                        }
                        catch (InterruptedException e) {
                            throw new DebugTimeoutException(e);
                        }
                    }
                }
                Object value = null;
                try {
                    value = node.evaluate(context, scope);
                }
                catch (Exception e) {
                    MagicScriptError.error(e.getMessage(), node.getSpan(), e);
                }
                if (value != Break.BREAK_SENTINEL && value != Continue.CONTINUE_SENTINEL && !(value instanceof Return.ReturnValue)) continue;
                return value;
            }
        }
        return null;
    }
}

