/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import org.ssssssss.script.parsing.Span;

public class CharacterStream {
    private final String source;
    private final int end;
    private int index;
    private int spanStart = 0;

    public CharacterStream(String source) {
        this(source, 0, source.length());
    }

    public CharacterStream(String source, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Start must be <= end.");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Start must be >= 0.");
        }
        if (start > Math.max(0, source.length() - 1)) {
            throw new IndexOutOfBoundsException("Start outside of string.");
        }
        if (end > source.length()) {
            throw new IndexOutOfBoundsException("End outside of string.");
        }
        this.source = source;
        this.index = start;
        this.end = end;
    }

    public String substring(int startIndex, int endIndex) {
        return this.source.substring(startIndex, endIndex);
    }

    public boolean hasMore() {
        return this.index < this.end;
    }

    public Span getSpan(int start, int end) {
        return new Span(this.source, start, end);
    }

    public char consume() {
        if (!this.hasMore()) {
            throw new RuntimeException("No more characters in stream.");
        }
        return this.source.charAt(this.index++);
    }

    public boolean match(String needle, boolean consume) {
        int needleLength = needle.length();
        if (needleLength + this.index > this.end) {
            return false;
        }
        int i = 0;
        int j = this.index;
        while (i < needleLength) {
            if (this.index >= this.end) {
                return false;
            }
            if (needle.charAt(i) != this.source.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        if (consume) {
            this.index += needleLength;
        }
        return true;
    }

    public boolean matchDigit(boolean consume) {
        if (this.index >= this.end) {
            return false;
        }
        char c = this.source.charAt(this.index);
        if (Character.isDigit(c)) {
            if (consume) {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public boolean matchIdentifierStart(boolean consume) {
        if (this.index >= this.end) {
            return false;
        }
        char c = this.source.charAt(this.index);
        if (Character.isJavaIdentifierStart(c) || c == '@') {
            if (consume) {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public boolean matchIdentifierPart(boolean consume) {
        if (this.index >= this.end) {
            return false;
        }
        char c = this.source.charAt(this.index);
        if (Character.isJavaIdentifierPart(c)) {
            if (consume) {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public void skipLine() {
        while (this.index < this.end && this.source.charAt(this.index++) != '\n') {
        }
    }

    public boolean skipUntil(String chars) {
        while (this.index < this.end) {
            boolean matched = true;
            int len = chars.length();
            for (int i = 0; i < len && this.index + i < this.end; ++i) {
                if (chars.charAt(i) == this.source.charAt(this.index + i)) continue;
                matched = false;
                break;
            }
            this.index += matched ? chars.length() : 1;
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public void skipWhiteSpace() {
        char c;
        while (this.index < this.end && ((c = this.source.charAt(this.index)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++this.index;
        }
    }

    public void startSpan() {
        this.spanStart = this.index;
    }

    public Span endSpan() {
        return new Span(this.source, this.spanStart, this.index);
    }

    public Span endSpan(int offset) {
        return new Span(this.source, this.spanStart, this.index + offset);
    }

    public Span endSpan(int start, int end) {
        return new Span(this.source, start, end);
    }

    public int getPosition() {
        return this.index;
    }

    public void reset(int position) {
        this.index = position;
    }
}

