/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenStream;
import org.ssssssss.script.parsing.TokenType;
import org.ssssssss.script.parsing.Tokenizer;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.LanguageExpression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.TernaryOperation;
import org.ssssssss.script.parsing.ast.UnaryOperation;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.binary.AssigmentOperation;
import org.ssssssss.script.parsing.ast.linq.LinqField;
import org.ssssssss.script.parsing.ast.linq.LinqJoin;
import org.ssssssss.script.parsing.ast.linq.LinqOrder;
import org.ssssssss.script.parsing.ast.linq.LinqSelect;
import org.ssssssss.script.parsing.ast.linq.WholeLiteral;
import org.ssssssss.script.parsing.ast.literal.BigDecimalLiteral;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.parsing.ast.literal.ByteLiteral;
import org.ssssssss.script.parsing.ast.literal.DoubleLiteral;
import org.ssssssss.script.parsing.ast.literal.FloatLiteral;
import org.ssssssss.script.parsing.ast.literal.IntegerLiteral;
import org.ssssssss.script.parsing.ast.literal.ListLiteral;
import org.ssssssss.script.parsing.ast.literal.LongLiteral;
import org.ssssssss.script.parsing.ast.literal.MapLiteral;
import org.ssssssss.script.parsing.ast.literal.NullLiteral;
import org.ssssssss.script.parsing.ast.literal.RegexpLiteral;
import org.ssssssss.script.parsing.ast.literal.ShortLiteral;
import org.ssssssss.script.parsing.ast.literal.StringLiteral;
import org.ssssssss.script.parsing.ast.statement.Assert;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.parsing.ast.statement.Break;
import org.ssssssss.script.parsing.ast.statement.ClassConverter;
import org.ssssssss.script.parsing.ast.statement.Continue;
import org.ssssssss.script.parsing.ast.statement.Exit;
import org.ssssssss.script.parsing.ast.statement.ForStatement;
import org.ssssssss.script.parsing.ast.statement.FunctionCall;
import org.ssssssss.script.parsing.ast.statement.IfStatement;
import org.ssssssss.script.parsing.ast.statement.Import;
import org.ssssssss.script.parsing.ast.statement.LambdaFunction;
import org.ssssssss.script.parsing.ast.statement.MapOrArrayAccess;
import org.ssssssss.script.parsing.ast.statement.MemberAccess;
import org.ssssssss.script.parsing.ast.statement.MethodCall;
import org.ssssssss.script.parsing.ast.statement.NewStatement;
import org.ssssssss.script.parsing.ast.statement.Return;
import org.ssssssss.script.parsing.ast.statement.Spread;
import org.ssssssss.script.parsing.ast.statement.TryStatement;
import org.ssssssss.script.parsing.ast.statement.VariableAccess;
import org.ssssssss.script.parsing.ast.statement.VariableDefine;
import org.ssssssss.script.parsing.ast.statement.WhileStatement;

public class Parser {
    private static final TokenType[][] binaryOperatorPrecedence = new TokenType[][]{{TokenType.Assignment}, {TokenType.PlusEqual, TokenType.MinusEqual, TokenType.AsteriskEqual, TokenType.ForwardSlashEqual, TokenType.PercentEqual}, {TokenType.Or, TokenType.And, TokenType.SqlOr, TokenType.SqlAnd, TokenType.Xor}, {TokenType.EqualEqualEqual, TokenType.Equal, TokenType.NotEqualEqual, TokenType.NotEqual, TokenType.SqlNotEqual}, {TokenType.Plus, TokenType.Minus}, {TokenType.Less, TokenType.LessEqual, TokenType.Greater, TokenType.GreaterEqual}, {TokenType.ForwardSlash, TokenType.Asterisk, TokenType.Percentage}};
    private static final TokenType[][] linqBinaryOperatorPrecedence = new TokenType[][]{{TokenType.PlusEqual, TokenType.MinusEqual, TokenType.AsteriskEqual, TokenType.ForwardSlashEqual, TokenType.PercentEqual}, {TokenType.Or, TokenType.And, TokenType.SqlOr, TokenType.SqlAnd, TokenType.Xor}, {TokenType.Assignment, TokenType.EqualEqualEqual, TokenType.Equal, TokenType.NotEqualEqual, TokenType.NotEqual, TokenType.SqlNotEqual}, {TokenType.Plus, TokenType.Minus}, {TokenType.Less, TokenType.LessEqual, TokenType.Greater, TokenType.GreaterEqual}, {TokenType.ForwardSlash, TokenType.Asterisk, TokenType.Percentage}};
    private static final TokenType[] unaryOperators = new TokenType[]{TokenType.Not, TokenType.PlusPlus, TokenType.MinusMinus, TokenType.Plus, TokenType.Minus};
    private static final List<String> keywords = Arrays.asList("import", "as", "var", "return", "break", "continue", "if", "for", "in", "new", "true", "false", "null", "else", "try", "catch", "finally", "async", "while", "exit", "and", "or");
    private static final List<String> linqKeywords = Arrays.asList("from", "join", "left", "group", "by", "as", "having", "and", "or", "in", "where", "on");
    private final Stack<List<String>> varNames = new Stack();
    private List<String> current = new ArrayList<String>();
    private int linqLevel = 0;

    public int getTopVarCount() {
        return this.current.size();
    }

    public List<Node> parse(String source) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        TokenStream stream = Tokenizer.tokenize(source);
        while (stream.hasMore()) {
            Node node = this.parseStatement(stream);
            if (node == null) continue;
            this.validateNode(node);
            nodes.add(node);
        }
        return nodes;
    }

    private void validateNode(Node node) {
        if (node instanceof Literal || node instanceof VariableAccess || node instanceof MapOrArrayAccess) {
            MagicScriptError.error("literal cannot be used alone", node.getSpan());
        }
    }

    private Node parseStatement(TokenStream tokens) {
        return this.parseStatement(tokens, false);
    }

    private Node parseStatement(TokenStream tokens, boolean expectRightCurly) {
        Node result = tokens.match("import", false) ? this.parseImport(tokens) : (tokens.match("var", false) ? this.parseVarDefine(tokens) : (tokens.match("if", false) ? this.parseIfStatement(tokens) : (tokens.match("return", false) ? this.parseReturn(tokens) : (tokens.match("for", false) ? this.parseForStatement(tokens) : (tokens.match("while", false) ? this.parseWhileStatement(tokens) : (tokens.match("continue", false) ? new Continue(tokens.consume().getSpan()) : (tokens.match("async", false) ? this.parseAsync(tokens) : (tokens.match("try", false) ? this.parseTryStatement(tokens) : (tokens.match("break", false) ? new Break(tokens.consume().getSpan()) : (tokens.match("exit", false) ? this.parseExit(tokens) : (tokens.match("assert", false) ? this.parseAssert(tokens) : this.parseExpression(tokens, expectRightCurly))))))))))));
        while (tokens.match(";", true)) {
        }
        return result;
    }

    private VarIndex add(String name) {
        int index = this.current.lastIndexOf(name);
        if (index > -1) {
            return new VarIndex(name, index, true);
        }
        index = this.current.size();
        this.current.add(name);
        return new VarIndex(name, index, true);
    }

    private VarIndex forceAdd(String name) {
        int index = this.current.size();
        this.current.add(name);
        return new VarIndex(name, index, false);
    }

    private void push() {
        this.varNames.push(this.current);
        this.current = new ArrayList<String>();
    }

    private int pop() {
        int count = this.current.size();
        this.current = this.varNames.pop();
        return count;
    }

    private Node parseExit(TokenStream stream) {
        Span opening = stream.expect("exit").getSpan();
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        do {
            expressionList.add(this.parseExpression(stream));
        } while (stream.match(TokenType.Comma, true));
        return new Exit(new Span(opening, stream.getPrev().getSpan()), expressionList);
    }

    private Node parseAssert(TokenStream stream) {
        int index = stream.makeIndex();
        try {
            Span opening = stream.expect("assert").getSpan();
            Expression condition = this.parseExpression(stream);
            stream.expect(TokenType.Colon);
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            do {
                expressionList.add(this.parseExpression(stream));
            } while (stream.match(TokenType.Comma, true));
            return new Assert(new Span(opening, stream.getPrev().getSpan()), condition, expressionList);
        }
        catch (Exception e) {
            stream.resetIndex(index);
            return this.parseExpression(stream);
        }
    }

    private Expression parseAsync(TokenStream stream) {
        Span opening = stream.expect("async").getSpan();
        Expression expression = this.parseExpression(stream);
        if (expression instanceof MethodCall || expression instanceof FunctionCall || expression instanceof LambdaFunction) {
            return new AsyncCall(new Span(opening, stream.getPrev().getSpan()), expression);
        }
        MagicScriptError.error("Expected MethodCall or FunctionCall or LambdaFunction", stream.getPrev().getSpan());
        return null;
    }

    private Import parseImport(TokenStream stream) {
        Span opening = stream.expect("import").getSpan();
        if (stream.hasMore()) {
            boolean isStringLiteral;
            Token expected = stream.consume();
            String packageName = null;
            boolean bl = isStringLiteral = expected.getType() == TokenType.StringLiteral;
            if (isStringLiteral) {
                packageName = new StringLiteral(expected.getSpan()).getValue();
            } else if (expected.getType() == TokenType.Identifier) {
                packageName = expected.getSpan().getText();
            } else {
                MagicScriptError.error("Expected identifier or string, but got stream is " + expected.getType().getError(), stream.getPrev().getSpan());
            }
            String varName = packageName;
            if (isStringLiteral) {
                if (stream.match("as", true)) {
                    expected = stream.expect(TokenType.Identifier);
                    this.checkKeyword(expected.getSpan());
                    varName = expected.getSpan().getText();
                } else {
                    String temp = new StringLiteral(expected.getSpan()).getValue();
                    if (!temp.startsWith("@")) {
                        int index = temp.lastIndexOf(".");
                        if (index != -1) {
                            temp = temp.substring(index + 1);
                        }
                    } else {
                        MagicScriptError.error("Expected as", stream);
                    }
                    varName = temp;
                }
            }
            return new Import(new Span(opening, expected.getSpan()), packageName, this.add(varName), !isStringLiteral);
        }
        MagicScriptError.error("Expected identifier or string, but got stream is EOF", stream.getPrev().getSpan());
        return null;
    }

    private TryStatement parseTryStatement(TokenStream stream) {
        Token opening = stream.expect("try");
        this.push();
        List<Node> tryBlocks = this.parseFunctionBody(stream);
        int tryVarCount = this.pop();
        ArrayList<Node> catchBlocks = new ArrayList<Node>();
        ArrayList<Node> finallyBlocks = new ArrayList<Node>();
        int catchVarCount = 0;
        VarIndex exceptionVarNode = null;
        if (stream.match("catch", true)) {
            this.push();
            if (stream.match("(", true)) {
                exceptionVarNode = this.add(stream.expect(TokenType.Identifier).getText());
                stream.expect(")");
            }
            catchBlocks.addAll(this.parseFunctionBody(stream));
            catchVarCount = this.pop();
        }
        int finallyVarCount = 0;
        if (stream.match("finally", true)) {
            this.push();
            finallyBlocks.addAll(this.parseFunctionBody(stream));
            finallyVarCount = this.pop();
        }
        return new TryStatement(new Span(opening.getSpan(), stream.getPrev().getSpan()), exceptionVarNode, tryBlocks, catchBlocks, finallyBlocks, tryVarCount, catchVarCount, finallyVarCount);
    }

    private List<Node> parseFunctionBody(TokenStream stream) {
        stream.expect("{");
        ArrayList<Node> blocks = new ArrayList<Node>();
        while (stream.hasMore() && !stream.match("}", false)) {
            Node node = this.parseStatement(stream, true);
            if (node == null) continue;
            this.validateNode(node);
            blocks.add(node);
        }
        Parser.expectCloseing(stream);
        return blocks;
    }

    private Expression parseNewExpression(Span opening, TokenStream stream) {
        Expression expression = this.parseAccessOrCall(stream, TokenType.Identifier, true);
        if (expression instanceof MethodCall) {
            MethodCall call = (MethodCall)expression;
            Span span = new Span(opening.getSource(), opening.getStart(), stream.getPrev().getSpan().getEnd());
            return this.parseConverterOrAccessOrCall(stream, new NewStatement(span, call.getMethod(), call.getArguments()));
        }
        if (expression instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)expression;
            Span span = new Span(opening.getSource(), opening.getStart(), stream.getPrev().getSpan().getEnd());
            return this.parseConverterOrAccessOrCall(stream, new NewStatement(span, call.getFunction(), call.getArguments()));
        }
        MagicScriptError.error("Expected MethodCall or FunctionCall or LambdaFunction", stream.getPrev().getSpan());
        return null;
    }

    private VariableDefine parseVarDefine(TokenStream stream) {
        Span opening = stream.expect("var").getSpan();
        Token token = stream.expect(TokenType.Identifier);
        this.checkKeyword(token.getSpan());
        String variableName = token.getSpan().getText();
        if (stream.match(TokenType.Assignment, true)) {
            return new VariableDefine(new Span(opening, stream.getPrev().getSpan()), this.forceAdd(variableName), this.parseExpression(stream));
        }
        return new VariableDefine(new Span(opening, stream.getPrev().getSpan()), this.forceAdd(variableName), null);
    }

    private void checkKeyword(Span span) {
        if (keywords.contains(span.getText())) {
            MagicScriptError.error("\u53d8\u91cf\u540d\u4e0d\u80fd\u5b9a\u4e49\u4e3a\u5173\u952e\u5b57", span);
        }
    }

    private WhileStatement parseWhileStatement(TokenStream stream) {
        Span openingWhile = stream.expect("while").getSpan();
        Expression condition = this.parseExpression(stream);
        this.push();
        List<Node> trueBlock = this.parseFunctionBody(stream);
        Span closingEnd = stream.getPrev().getSpan();
        return new WhileStatement(new Span(openingWhile, closingEnd), condition, trueBlock, this.pop());
    }

    private ForStatement parseForStatement(TokenStream stream) {
        Span openingFor = stream.expect("for").getSpan();
        stream.expect("(");
        this.push();
        Span index = null;
        Span value = stream.expect(TokenType.Identifier).getSpan();
        this.checkKeyword(value);
        if (stream.match(TokenType.Comma, true)) {
            index = value;
            value = stream.expect(TokenType.Identifier).getSpan();
            this.checkKeyword(value);
        }
        VarIndex indexOrKeyNode = null;
        if (index != null) {
            indexOrKeyNode = this.forceAdd(index.getText());
        }
        VarIndex valueNode = this.forceAdd(value.getText());
        stream.expect("in");
        Expression mapOrArray = this.parseExpression(stream);
        stream.expect(")");
        List<Node> body = this.parseFunctionBody(stream);
        return new ForStatement(new Span(openingFor, stream.getPrev().getSpan()), indexOrKeyNode, valueNode, this.pop(), mapOrArray, body);
    }

    private static Span expectCloseing(TokenStream stream) {
        if (!stream.hasMore()) {
            MagicScriptError.error("Did not find closing }.", stream.prev().getSpan());
        }
        return stream.expect("}").getSpan();
    }

    private Node parseIfStatement(TokenStream stream) {
        Span openingIf = stream.expect("if").getSpan();
        Expression condition = this.parseExpression(stream);
        this.push();
        List<Node> trueBlock = this.parseFunctionBody(stream);
        int trueVarCount = this.pop();
        ArrayList<IfStatement> elseIfs = new ArrayList<IfStatement>();
        ArrayList<Node> falseBlock = new ArrayList<Node>();
        int falseVarCount = 0;
        while (stream.hasMore() && stream.match("else", true)) {
            if (stream.hasMore() && stream.match("if", false)) {
                Span elseIfOpening = stream.expect("if").getSpan();
                Expression elseIfCondition = this.parseExpression(stream);
                this.push();
                List<Node> elseIfBlock = this.parseFunctionBody(stream);
                Span elseIfSpan = new Span(elseIfOpening, elseIfBlock.size() > 0 ? elseIfBlock.get(elseIfBlock.size() - 1).getSpan() : elseIfOpening);
                elseIfs.add(new IfStatement(elseIfSpan, elseIfCondition, elseIfBlock, new ArrayList<IfStatement>(), new ArrayList<Node>(), this.pop(), 0));
                continue;
            }
            this.push();
            falseBlock.addAll(this.parseFunctionBody(stream));
            falseVarCount = this.pop();
            break;
        }
        Span closingEnd = stream.getPrev().getSpan();
        return new IfStatement(new Span(openingIf, closingEnd), condition, trueBlock, elseIfs, falseBlock, trueVarCount, falseVarCount);
    }

    private Node parseReturn(TokenStream tokens) {
        Span returnSpan = tokens.expect("return").getSpan();
        if (tokens.match(";", false)) {
            return new Return(returnSpan, null);
        }
        Expression returnValue = this.parseExpression(tokens);
        return new Return(new Span(returnSpan, returnValue.getSpan()), returnValue);
    }

    public Expression parseExpression(TokenStream stream) {
        return this.parseTernaryOperator(stream);
    }

    public Expression parseExpression(TokenStream stream, boolean expectRightCurly) {
        return this.parseTernaryOperator(stream, expectRightCurly);
    }

    private Expression parseTernaryOperator(TokenStream stream, boolean expectRightCurly) {
        Expression condition = this.parseBinaryOperator(stream, 0, expectRightCurly);
        if (stream.match(TokenType.QuestionMark, true)) {
            Expression trueExpression = this.parseTernaryOperator(stream, expectRightCurly);
            stream.expect(TokenType.Colon);
            Expression falseExpression = this.parseTernaryOperator(stream, expectRightCurly);
            if (condition instanceof AssigmentOperation) {
                AssigmentOperation operation = (AssigmentOperation)condition;
                operation.setRightOperand(new TernaryOperation(operation.getRightOperand(), trueExpression, falseExpression));
                return operation;
            }
            return new TernaryOperation(condition, trueExpression, falseExpression);
        }
        return condition;
    }

    private Expression parseTernaryOperator(TokenStream stream) {
        return this.parseTernaryOperator(stream, false);
    }

    private Expression parseBinaryOperator(TokenStream stream, TokenType[][] precedence, int level, boolean expectRightCurly) {
        int nextLevel = level + 1;
        Expression left = nextLevel == precedence.length ? this.parseUnaryOperator(stream, expectRightCurly) : this.parseBinaryOperator(stream, nextLevel, expectRightCurly);
        TokenType[] operators = precedence[level];
        while (stream.hasMore() && stream.match(false, operators)) {
            Token operator = stream.consume();
            if (operator.getType().isInLinq() && this.linqLevel == 0) {
                MagicScriptError.error(operator.getText() + " \u53ea\u80fd\u5728Linq\u4e2d\u4f7f\u7528", stream);
            }
            Expression right = nextLevel == precedence.length ? this.parseUnaryOperator(stream, expectRightCurly) : this.parseBinaryOperator(stream, nextLevel, expectRightCurly);
            left = BinaryOperation.create(left, operator, right, this.linqLevel);
        }
        return left;
    }

    private Expression parseBinaryOperator(TokenStream stream, int level, boolean expectRightCurly) {
        if (this.linqLevel > 0) {
            return this.parseBinaryOperator(stream, linqBinaryOperatorPrecedence, level, expectRightCurly);
        }
        return this.parseBinaryOperator(stream, binaryOperatorPrecedence, level, expectRightCurly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parseUnaryOperator(TokenStream stream, boolean expectRightCurly) {
        if (stream.match(false, unaryOperators)) {
            return new UnaryOperation(stream.consume(), this.parseUnaryOperator(stream, expectRightCurly));
        }
        if (stream.match(TokenType.LeftParantheses, false)) {
            Span openSpan = stream.expect(TokenType.LeftParantheses).getSpan();
            int index = stream.makeIndex();
            ArrayList<VarIndex> parameters = new ArrayList<VarIndex>();
            this.push();
            try {
                Object identifier;
                while (stream.match(TokenType.Identifier, false)) {
                    identifier = stream.expect(TokenType.Identifier);
                    parameters.add(this.forceAdd(((Token)identifier).getSpan().getText()));
                    if (stream.match(TokenType.Comma, true)) continue;
                    if (!stream.match(TokenType.RightParantheses, true)) continue;
                    if (!stream.match(TokenType.Lambda, true)) break;
                    Expression expression = this.parseLambdaBody(stream, openSpan, parameters);
                    return expression;
                }
                if (stream.match(TokenType.RightParantheses, true) && stream.match(TokenType.Lambda, true)) {
                    identifier = this.parseLambdaBody(stream, openSpan, parameters);
                    return identifier;
                }
            }
            finally {
                this.pop();
            }
            stream.resetIndex(index);
            Expression expression = this.parseExpression(stream);
            stream.expect(TokenType.RightParantheses);
            return this.parseConverterOrAccessOrCall(stream, expression);
        }
        Expression expression = this.parseAccessOrCallOrLiteral(stream, expectRightCurly);
        if (expression instanceof VariableSetter && stream.match(false, TokenType.PlusPlus, TokenType.MinusMinus)) {
            return new UnaryOperation(stream.consume(), expression, true);
        }
        return expression;
    }

    private Expression parseConverterOrAccessOrCall(TokenStream stream, Expression expression) {
        while (stream.match(false, TokenType.Period, TokenType.QuestionPeriod, TokenType.ColonColon)) {
            if (stream.match(TokenType.ColonColon, false)) {
                Span open = stream.consume().getSpan();
                List<Expression> arguments = Collections.emptyList();
                Token identifier = stream.expect(TokenType.Identifier);
                Span closing = identifier.getSpan();
                if (stream.match(TokenType.LeftParantheses, false)) {
                    arguments = this.parseArguments(stream);
                    closing = stream.expect(TokenType.RightParantheses).getSpan();
                }
                expression = new ClassConverter(new Span(open, closing), identifier.getText(), expression, arguments);
                continue;
            }
            expression = this.parseAccessOrCall(stream, expression, false);
        }
        return expression;
    }

    private Expression parseLambdaBody(TokenStream stream, Span openSpan, List<VarIndex> parameters) {
        int index = stream.makeIndex();
        ArrayList<Node> childNodes = new ArrayList<Node>();
        try {
            Expression expression = this.parseExpression(stream);
            childNodes.add(new Return(new Span("return", 0, 6), expression));
            return new LambdaFunction(new Span(openSpan, expression.getSpan()), parameters, this.current.size(), childNodes);
        }
        catch (Exception e) {
            stream.resetIndex(index);
            if (stream.match(TokenType.LeftCurly, true)) {
                while (stream.hasMore() && !stream.match(false, "}")) {
                    Node node = this.parseStatement(stream, true);
                    this.validateNode(node);
                    childNodes.add(node);
                }
                Span closeSpan = Parser.expectCloseing(stream);
                return new LambdaFunction(new Span(openSpan, closeSpan), parameters, this.current.size(), childNodes);
            }
            Node node = this.parseStatement(stream);
            childNodes.add(new Return(new Span("return", 0, 6), node));
            return new LambdaFunction(new Span(openSpan, node.getSpan()), parameters, this.current.size(), childNodes);
        }
    }

    private Expression parseSpreadAccess(TokenStream stream, Token spread) {
        Expression target = this.parseExpression(stream);
        return new Spread(new Span(spread.getSpan(), target.getSpan()), target);
    }

    private Expression parseSpreadAccess(TokenStream stream) {
        Token spread = stream.expect(TokenType.Spread);
        return this.parseSpreadAccess(stream, spread);
    }

    private Expression parseSelect(TokenStream stream) {
        Span opeing = stream.expect("select", true).getSpan();
        ++this.linqLevel;
        List<LinqField> fields = this.parseLinqFields(stream);
        stream.expect("from", true);
        LinqField from = this.parseLinqField(stream);
        List<LinqJoin> joins = this.parseLinqJoins(stream);
        Expression where = null;
        if (stream.match("where", true, true)) {
            where = this.parseExpression(stream);
        }
        List<LinqField> groups = this.parseGroup(stream);
        Expression having = null;
        if (stream.match("having", true, true)) {
            having = this.parseExpression(stream);
        }
        List<LinqOrder> orders = this.parseLinqOrders(stream);
        --this.linqLevel;
        Span close = stream.getPrev().getSpan();
        return new LinqSelect(new Span(opeing, close), fields, from, joins, where, groups, having, orders);
    }

    private List<LinqField> parseGroup(TokenStream stream) {
        ArrayList<LinqField> groups = new ArrayList<LinqField>();
        if (stream.match("group", true, true)) {
            stream.expect("by", true);
            do {
                Expression expression = this.parseExpression(stream);
                groups.add(new LinqField(expression.getSpan(), expression, null));
            } while (stream.match(TokenType.Comma, true));
        }
        return groups;
    }

    private List<LinqOrder> parseLinqOrders(TokenStream stream) {
        ArrayList<LinqOrder> orders = new ArrayList<LinqOrder>();
        if (stream.match("order", true, true)) {
            stream.expect("by", true);
            do {
                Expression expression = this.parseExpression(stream);
                int order = 1;
                if (stream.match(false, true, "desc", "asc") && "desc".equalsIgnoreCase(stream.consume().getText())) {
                    order = -1;
                }
                orders.add(new LinqOrder(new Span(expression.getSpan(), stream.getPrev().getSpan()), expression, null, order));
            } while (stream.match(TokenType.Comma, true));
        }
        return orders;
    }

    private List<LinqField> parseLinqFields(TokenStream stream) {
        ArrayList<LinqField> fields = new ArrayList<LinqField>();
        do {
            Expression expression = this.parseExpression(stream);
            if (stream.match(TokenType.Identifier, false) && !stream.match(linqKeywords, false, true)) {
                if (expression instanceof WholeLiteral) {
                    MagicScriptError.error("* \u540e\u8fb9\u4e0d\u80fd\u8ddf\u522b\u540d", stream);
                } else if (expression instanceof MemberAccess && ((MemberAccess)expression).isWhole()) {
                    MagicScriptError.error(expression.getSpan().getText() + " \u540e\u8fb9\u4e0d\u80fd\u8ddf\u522b\u540d", stream);
                }
                Span alias = stream.consume().getSpan();
                fields.add(new LinqField(new Span(expression.getSpan(), alias), expression, this.add(alias.getText())));
                continue;
            }
            fields.add(new LinqField(expression.getSpan(), expression, null));
        } while (stream.match(TokenType.Comma, true));
        if (fields.isEmpty()) {
            MagicScriptError.error("\u81f3\u5c11\u8981\u67e5\u8be2\u4e00\u4e2a\u5b57\u6bb5", stream);
        }
        return fields;
    }

    private List<LinqJoin> parseLinqJoins(TokenStream stream) {
        ArrayList<LinqJoin> joins = new ArrayList<LinqJoin>();
        do {
            boolean isLeft;
            Span opeing;
            Span span = opeing = (isLeft = stream.match("left", false, true)) ? stream.consume().getSpan() : null;
            if (!stream.match("join", true, true)) continue;
            opeing = isLeft ? opeing : stream.getPrev().getSpan();
            LinqField target = this.parseLinqField(stream);
            stream.expect("on", true);
            Expression condition = this.parseExpression(stream);
            joins.add(new LinqJoin(new Span(opeing, stream.getPrev().getSpan()), isLeft, target, condition));
        } while (stream.match(false, true, "left", "join"));
        return joins;
    }

    private LinqField parseLinqField(TokenStream stream) {
        Expression expression = this.parseExpression(stream);
        if (stream.match(TokenType.Identifier, false) && !stream.match(linqKeywords, false, true)) {
            Span alias = stream.expect(TokenType.Identifier).getSpan();
            return new LinqField(new Span(expression.getSpan(), alias), expression, this.add(alias.getText()));
        }
        return new LinqField(expression.getSpan(), expression, null);
    }

    private Expression parseAccessOrCallOrLiteral(TokenStream stream, boolean expectRightCurly) {
        Expression expression = null;
        if (expectRightCurly && stream.match("}", false)) {
            return null;
        }
        if (stream.match(TokenType.Spread, false)) {
            expression = this.parseSpreadAccess(stream);
        } else if (stream.match(TokenType.Identifier, false)) {
            expression = stream.match("async", false) ? this.parseAsync(stream) : (stream.match("select", false, true) ? this.parseSelect(stream) : this.parseAccessOrCall(stream, TokenType.Identifier, false));
        } else if (stream.match(TokenType.LeftCurly, false)) {
            expression = this.parseMapLiteral(stream);
        } else if (stream.match(TokenType.LeftBracket, false)) {
            expression = this.parseListLiteral(stream);
        } else if (stream.match(TokenType.StringLiteral, false)) {
            expression = new StringLiteral(stream.expect(TokenType.StringLiteral).getSpan());
        } else if (stream.match(TokenType.BooleanLiteral, false)) {
            expression = new BooleanLiteral(stream.expect(TokenType.BooleanLiteral).getSpan());
        } else if (stream.match(TokenType.DoubleLiteral, false)) {
            expression = new DoubleLiteral(stream.expect(TokenType.DoubleLiteral).getSpan());
        } else if (stream.match(TokenType.FloatLiteral, false)) {
            expression = new FloatLiteral(stream.expect(TokenType.FloatLiteral).getSpan());
        } else if (stream.match(TokenType.ByteLiteral, false)) {
            expression = new ByteLiteral(stream.expect(TokenType.ByteLiteral).getSpan());
        } else if (stream.match(TokenType.ShortLiteral, false)) {
            expression = new ShortLiteral(stream.expect(TokenType.ShortLiteral).getSpan());
        } else if (stream.match(TokenType.IntegerLiteral, false)) {
            expression = new IntegerLiteral(stream.expect(TokenType.IntegerLiteral).getSpan());
        } else if (stream.match(TokenType.LongLiteral, false)) {
            expression = new LongLiteral(stream.expect(TokenType.LongLiteral).getSpan());
        } else if (stream.match(TokenType.DecimalLiteral, false)) {
            expression = new BigDecimalLiteral(stream.expect(TokenType.DecimalLiteral).getSpan());
        } else if (stream.match(TokenType.RegexpLiteral, false)) {
            Token token = stream.expect(TokenType.RegexpLiteral);
            RegexpLiteral target = new RegexpLiteral(token.getSpan(), token);
            expression = this.parseAccessOrCall(stream, target, false);
        } else if (stream.match(TokenType.NullLiteral, false)) {
            expression = new NullLiteral(stream.expect(TokenType.NullLiteral).getSpan());
        } else if (this.linqLevel > 0 && stream.match(TokenType.Asterisk, false)) {
            expression = new WholeLiteral(stream.expect(TokenType.Asterisk).getSpan());
        } else if (stream.match(TokenType.Language, false)) {
            expression = new LanguageExpression(stream.consume().getSpan(), stream.consume().getSpan());
        }
        if (expression instanceof StringLiteral && stream.match(false, TokenType.Period, TokenType.QuestionPeriod)) {
            stream.prev();
            expression = this.parseAccessOrCall(stream, TokenType.StringLiteral, false);
        }
        if (expression == null) {
            MagicScriptError.error("Expected a variable, field, map, array, function or method call, or literal.", stream);
        }
        return this.parseConverterOrAccessOrCall(stream, expression);
    }

    private Expression parseMapLiteral(TokenStream stream) {
        Span openCurly = stream.expect(TokenType.LeftCurly).getSpan();
        ArrayList<Token> keys = new ArrayList<Token>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        while (stream.hasMore() && !stream.match("}", false)) {
            if (stream.hasPrev()) {
                Token prev = stream.getPrev();
                if (stream.match(TokenType.Spread, false) && (prev.getType() == TokenType.LeftCurly || prev.getType() == TokenType.Comma)) {
                    Token spread = stream.expect(TokenType.Spread);
                    keys.add(spread);
                    values.add(this.parseSpreadAccess(stream, spread));
                    if (!stream.match(false, TokenType.Comma, TokenType.RightCurly)) continue;
                    stream.match(TokenType.Comma, true);
                    continue;
                }
            }
            Token key = stream.match(TokenType.StringLiteral, false) ? stream.expect(TokenType.StringLiteral) : stream.expect(TokenType.Identifier);
            keys.add(key);
            if (stream.match(false, TokenType.Comma, TokenType.RightCurly)) {
                stream.match(TokenType.Comma, true);
                if (key.getType() == TokenType.Identifier) {
                    values.add(new VariableAccess(key.getSpan(), this.add(key.getText())));
                    continue;
                }
                values.add(new StringLiteral(key.getSpan()));
                continue;
            }
            stream.expect(":");
            values.add(this.parseExpression(stream));
            if (stream.match("}", false)) continue;
            stream.expect(TokenType.Comma);
        }
        Span closeCurly = stream.expect("}").getSpan();
        return new MapLiteral(new Span(openCurly, closeCurly), keys, values);
    }

    private Expression parseListLiteral(TokenStream stream) {
        Span openBracket = stream.expect(TokenType.LeftBracket).getSpan();
        ArrayList<Expression> values = new ArrayList<Expression>();
        while (stream.hasMore() && !stream.match(TokenType.RightBracket, false)) {
            values.add(this.parseExpression(stream));
            if (stream.match(TokenType.RightBracket, false)) continue;
            stream.expect(TokenType.Comma);
        }
        Span closeBracket = stream.expect(TokenType.RightBracket).getSpan();
        return this.parseConverterOrAccessOrCall(stream, new ListLiteral(new Span(openBracket, closeBracket), values));
    }

    private Expression parseAccessOrCall(TokenStream stream, TokenType tokenType, boolean isNew) {
        Span identifier = stream.expect(tokenType).getSpan();
        if (tokenType == TokenType.Identifier && "new".equals(identifier.getText())) {
            return this.parseNewExpression(identifier, stream);
        }
        if (tokenType == TokenType.Identifier && stream.match(TokenType.Lambda, true)) {
            this.push();
            Expression expression = this.parseLambdaBody(stream, identifier, Arrays.asList(this.forceAdd(identifier.getText())));
            this.pop();
            return expression;
        }
        Expression result = tokenType == TokenType.StringLiteral ? new StringLiteral(identifier) : new VariableAccess(identifier, this.add(identifier.getText()));
        return this.parseAccessOrCall(stream, result, isNew);
    }

    private Expression parseAccessOrCall(TokenStream stream, Expression target, boolean isNew) {
        while (stream.hasMore() && stream.match(false, TokenType.LeftParantheses, TokenType.LeftBracket, TokenType.Period, TokenType.QuestionPeriod)) {
            boolean optional;
            Span closingSpan;
            if (stream.match(TokenType.LeftParantheses, false)) {
                List<Expression> arguments = this.parseArguments(stream);
                closingSpan = stream.expect(TokenType.RightParantheses).getSpan();
                if (target instanceof VariableAccess || target instanceof MapOrArrayAccess) {
                    target = new FunctionCall(new Span(target.getSpan(), closingSpan), target, arguments, this.linqLevel > 0);
                } else if (target instanceof MemberAccess) {
                    target = new MethodCall(new Span(target.getSpan(), closingSpan), (MemberAccess)target, arguments, this.linqLevel > 0);
                } else {
                    MagicScriptError.error("Expected a variable, field or method.", stream);
                }
                if (!isNew) continue;
                break;
            }
            if (stream.match(TokenType.LeftBracket, true)) {
                Expression keyOrIndex = this.parseExpression(stream);
                closingSpan = stream.expect(TokenType.RightBracket).getSpan();
                target = new MapOrArrayAccess(new Span(target.getSpan(), closingSpan), target, keyOrIndex);
                continue;
            }
            if (!stream.match(false, TokenType.Period, TokenType.QuestionPeriod)) continue;
            boolean bl = optional = stream.consume().getType() == TokenType.QuestionPeriod;
            if (this.linqLevel > 0 && stream.match(TokenType.Asterisk, false)) {
                target = new MemberAccess(target, optional, stream.expect(TokenType.Asterisk).getSpan(), true);
                continue;
            }
            target = new MemberAccess(target, optional, stream.expect(TokenType.Identifier, TokenType.SqlAnd, TokenType.SqlOr).getSpan(), false);
        }
        return target;
    }

    private List<Expression> parseArguments(TokenStream stream) {
        stream.expect(TokenType.LeftParantheses);
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        while (stream.hasMore() && !stream.match(TokenType.RightParantheses, false)) {
            arguments.add(this.parseExpression(stream));
            if (stream.match(TokenType.RightParantheses, false)) continue;
            stream.expect(TokenType.Comma);
        }
        return arguments;
    }
}

