/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.Arrays;

public enum TokenType {
    Spread("...", "..."),
    Period(".", "."),
    QuestionPeriod("?.", "?."),
    Comma(",", ","),
    Semicolon(";", ";"),
    Colon(":", ":"),
    Plus("+", "+"),
    Minus("-", "-"),
    Asterisk("*", "*"),
    ForwardSlash("/", "/"),
    PostSlash("\\", "\\"),
    Percentage("%", "%"),
    LeftParantheses("(", ")"),
    RightParantheses(")", ")"),
    LeftBracket("[", "["),
    RightBracket("]", "]"),
    LeftCurly("{", "{"),
    RightCurly("}", "{"),
    Less("<", "<"),
    Greater(">", ">"),
    LessEqual("<=", "<="),
    GreaterEqual(">=", ">="),
    Equal("==", "=="),
    NotEqual("!=", "!="),
    Assignment("=", "="),
    PlusPlus("++", "++"),
    MinusMinus("--", "--"),
    PlusEqual("+=", "+="),
    MinusEqual("-=", "-="),
    AsteriskEqual("*=", "*="),
    ForwardSlashEqual("/=", "/="),
    PercentEqual("%=", "%="),
    ColonColon("::", "::"),
    EqualEqualEqual("===", "==="),
    NotEqualEqual("!==", "!=="),
    And("&&", "&&"),
    Or("||", "||"),
    Xor("^", "^"),
    Not("!", "!"),
    SqlAnd("and", "and", true),
    SqlOr("or", "or", true),
    SqlNotEqual("<>", "<>", true),
    QuestionMark("?", "?"),
    DoubleQuote("\"", "\""),
    TripleQuote("\"\"\"", "\"\"\""),
    SingleQuote("'", "'"),
    Lambda("=>"),
    RegexpLiteral("a regexp"),
    BooleanLiteral("true or false"),
    DoubleLiteral("a double floating point number"),
    DecimalLiteral("a decimal point number"),
    FloatLiteral("a floating point number"),
    LongLiteral("a long integer number"),
    IntegerLiteral("an integer number"),
    ShortLiteral("a short integer number"),
    ByteLiteral("a byte integer number"),
    CharacterLiteral("a character"),
    StringLiteral("a string"),
    NullLiteral("null"),
    Language("language"),
    Comment("comment"),
    Identifier("an identifier");

    private static final TokenType[] values;
    private final String literal;
    private final String error;
    private final boolean inLinq;

    private TokenType(String error) {
        this(null, error, false);
    }

    private TokenType(String literal, String error) {
        this(literal, error, false);
    }

    private TokenType(String literal, String error, boolean inLinq) {
        this.literal = literal;
        this.error = error;
        this.inLinq = inLinq;
    }

    public boolean isInLinq() {
        return this.inLinq;
    }

    public static TokenType[] getSortedValues() {
        return values;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getError() {
        return this.error;
    }

    static {
        values = TokenType.values();
        Arrays.sort(values, (o1, o2) -> {
            if (o1.literal == null && o2.literal == null) {
                return 0;
            }
            if (o1.literal == null && o2.literal != null) {
                return 1;
            }
            if (o1.literal != null && o2.literal == null) {
                return -1;
            }
            return o2.literal.length() - o1.literal.length();
        });
    }
}

