/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast;

import java.math.BigDecimal;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenType;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class UnaryOperation
extends Expression {
    private final UnaryOperator operator;
    private final Expression operand;
    private final boolean atAfter;

    public UnaryOperation(Token operator, Expression operand) {
        this(operator, operand, false);
    }

    public UnaryOperation(Token operator, Expression operand, boolean atAfter) {
        super(operator.getSpan());
        this.operator = UnaryOperator.getOperator(operator);
        this.operand = operand;
        this.atAfter = atAfter;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    private Expression getOperand() {
        return this.operand;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object value = this.getOperand().evaluate(context, scope);
        switch (this.getOperator()) {
            case Not: {
                return !BooleanLiteral.isTrue(value);
            }
            case PlusPlus: 
            case MinusMinus: {
                if (this.operand instanceof VariableSetter && value instanceof Number) {
                    Object result = this.addValue(value, this.getOperator() == UnaryOperator.PlusPlus ? 1 : -1);
                    ((VariableSetter)((Object)this.operand)).setValue(context, scope, result);
                    return this.atAfter ? value : result;
                }
                MagicScriptError.error("\u4e00\u5143\u64cd\u4f5c\u7b26[" + this.getOperator().name() + "] \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b\uff0c\u83b7\u5f97\u7684\u503c\u4e3a\uff1a" + this.operand, this.getSpan());
                return null;
            }
            case Negate: {
                if (value instanceof Integer) {
                    return -((Integer)value).intValue();
                }
                if (value instanceof Float) {
                    return Float.valueOf(-((Float)value).floatValue());
                }
                if (value instanceof Double) {
                    return -((Double)value).doubleValue();
                }
                if (value instanceof Byte) {
                    return (int)(-((Byte)value).byteValue());
                }
                if (value instanceof Short) {
                    return (int)(-((Short)value).shortValue());
                }
                if (value instanceof Long) {
                    return -((Long)value).longValue();
                }
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).negate();
                }
                MagicScriptError.error("\u4e00\u5143\u64cd\u4f5c\u7b26[" + this.getOperator().name() + "]\u7684\u503c\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b\uff0c\u83b7\u5f97\u7684\u503c\u4e3a\uff1a" + this.operand, this.getSpan());
            }
        }
        return this.operand;
    }

    private Object addValue(Object target, int value) {
        if (target instanceof Double) {
            return (Double)target + (double)value;
        }
        if (target instanceof Long) {
            return (Long)target + (long)value;
        }
        if (target instanceof Integer) {
            return (Integer)target + value;
        }
        if (target instanceof BigDecimal) {
            return ((BigDecimal)target).add(new BigDecimal(value));
        }
        if (target instanceof Float) {
            return Float.valueOf(((Float)target).floatValue() + (float)value);
        }
        if (target instanceof Byte) {
            return (Byte)target + value;
        }
        if (target instanceof Short) {
            return (Short)target + value;
        }
        return null;
    }

    public static enum UnaryOperator {
        Not,
        Negate,
        Positive,
        PlusPlus,
        MinusMinus;


        public static UnaryOperator getOperator(Token op) {
            if (op.getType() == TokenType.Not) {
                return Not;
            }
            if (op.getType() == TokenType.Plus) {
                return Positive;
            }
            if (op.getType() == TokenType.Minus) {
                return Negate;
            }
            if (op.getType() == TokenType.PlusPlus) {
                return PlusPlus;
            }
            if (op.getType() == TokenType.MinusMinus) {
                return MinusMinus;
            }
            MagicScriptError.error("\u4e0d\u652f\u6301\u7684\u4e00\u5143\u64cd\u4f5c\u7b26\uff1a" + op, op.getSpan());
            return null;
        }
    }
}

