/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.binary;

import java.math.BigDecimal;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;

public class PercentEqualOperation
extends BinaryOperation {
    public PercentEqualOperation(Expression leftOperand, Span span, Expression rightOperand) {
        super(leftOperand, span, rightOperand);
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object right;
        Object left = this.getLeftOperand().evaluate(context, scope);
        if (!(this.getLeftOperand() instanceof VariableSetter)) {
            MagicScriptError.error(this.getLeftOperand().getSpan().getText() + " \u5e94\u8be5\u53ef\u5199", this.getLeftOperand().getSpan());
        }
        if ((right = this.getRightOperand().evaluate(context, scope)) == null) {
            MagicScriptError.error(this.getRightOperand().getSpan().getText() + " \u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c[%=]\u64cd\u4f5c", this.getRightOperand().getSpan());
        }
        Number value = null;
        if (left instanceof Double || right instanceof Double) {
            value = ((Number)left).doubleValue() % ((Number)right).doubleValue();
        } else if (left instanceof Long || right instanceof Long) {
            value = ((Number)left).longValue() % ((Number)right).longValue();
        } else if (left instanceof Integer || right instanceof Integer) {
            value = ((Number)left).intValue() % ((Number)right).intValue();
        } else if (left instanceof BigDecimal || right instanceof BigDecimal) {
            value = ObjectConvertExtension.asDecimal(left).remainder(ObjectConvertExtension.asDecimal(right));
        } else if (left instanceof Float || right instanceof Float) {
            value = Float.valueOf(((Number)left).floatValue() % ((Number)right).floatValue());
        } else if (left instanceof Short || right instanceof Short) {
            value = ((Number)left).shortValue() % ((Number)right).shortValue();
        } else if (left instanceof Byte || right instanceof Byte) {
            value = ((Number)left).byteValue() % ((Number)right).byteValue();
        } else {
            MagicScriptError.error("[%=]\u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b, \u83b7\u5f97\u7684\u503c\u4e3a\uff1a " + left + ", " + right, this.getSpan());
        }
        ((VariableSetter)((Object)this.getLeftOperand())).setValue(context, scope, value);
        return value;
    }
}

