/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.linq;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.functions.MapExtension;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.statement.MemberAccess;

public class LinqField
extends Expression
implements VariableSetter {
    private final Expression expression;
    private final String aliasName;
    private final VarIndex varIndex;
    private final boolean hasAlias;

    public LinqField(Span span, Expression expression, VarIndex alias) {
        super(span);
        this.expression = expression;
        this.hasAlias = alias != null;
        this.aliasName = this.hasAlias ? alias.getName() : expression.getSpan().getText();
        this.varIndex = alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        if (this.expression instanceof MemberAccess && ((MemberAccess)this.expression).isWhole()) {
            return ((MemberAccess)this.expression).getObject().evaluate(context, scope);
        }
        return this.expression.evaluate(context, scope);
    }

    public List<Object> evaluateList(MagicScriptContext context, Scope scope) {
        List<Object> objects;
        Object target = this.expression.evaluate(context, scope);
        if (target instanceof Map) {
            List<?> list = MapExtension.asList((Map)target, entry -> Collections.singletonMap(entry[0], entry[1]));
        }
        try {
            objects = StreamExtension.arrayLikeToList(target);
        }
        catch (Exception e) {
            return Collections.singletonList(target);
        }
        return objects;
    }

    public boolean isHasAlias() {
        return this.hasAlias;
    }

    public String getAlias() {
        return this.aliasName;
    }

    @Override
    public void setValue(MagicScriptContext context, Scope scope, Object value) {
        if (this.hasAlias) {
            scope.setValue(this.varIndex, value);
        }
    }
}

