/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.linq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.linq.LinqField;
import org.ssssssss.script.parsing.ast.linq.LinqJoin;
import org.ssssssss.script.parsing.ast.linq.LinqOrder;
import org.ssssssss.script.parsing.ast.linq.WholeLiteral;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class LinqSelect
extends Expression {
    private final List<LinqField> fields;
    private final LinqField from;
    private final List<LinqJoin> joins;
    private final Expression where;
    private final List<LinqField> groups;
    private final Expression having;
    private final List<LinqOrder> orders;

    public LinqSelect(Span span, List<LinqField> fields, LinqField from, List<LinqJoin> joins, Expression where, List<LinqField> groups, Expression having, List<LinqOrder> orders) {
        super(span);
        this.fields = fields;
        this.from = from;
        this.joins = joins;
        this.where = where;
        this.groups = groups;
        this.having = having;
        this.orders = orders;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        List<Object> objects = this.from.evaluateList(context, scope);
        ArrayList<SelectValue> result = new ArrayList<SelectValue>();
        ArrayList<Record> records = new ArrayList<Record>();
        for (Object object : objects) {
            this.from.setValue(context, scope, object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (LinqJoin join : this.joins) {
                join.setCachedValue(join.getTarget().evaluateList(context, scope));
                arrayList.add(join.evaluate(context, scope));
            }
            if (this.joins.isEmpty()) {
                arrayList.add(Collections.singletonList(object));
            }
            if (this.where != null) {
                int maxSize = arrayList.stream().mapToInt(List::size).sum();
                int size = arrayList.size();
                for (int v = 0; v < size; ++v) {
                    List values = (List)arrayList.get(v);
                    if (values.isEmpty()) continue;
                    LinqJoin join = this.joins.isEmpty() ? null : this.joins.get(v);
                    for (int i = 0; i < maxSize; ++i) {
                        Object value = values.get(Math.min(values.size() - 1, i));
                        if (join != null) {
                            join.getTarget().setValue(context, scope, value);
                        }
                        if (!BooleanLiteral.isTrue(this.where.evaluate(context, scope))) continue;
                        records.add(new Record(object, join, join == null ? null : value));
                    }
                }
                continue;
            }
            if (!this.joins.isEmpty()) {
                int size = this.joins.size();
                for (int i = 0; i < size; ++i) {
                    List values = (List)arrayList.get(i);
                    if (this.joins.get(i).isLeftJoin()) {
                        if (!values.isEmpty()) {
                            for (Object value : values) {
                                records.add(new Record(object, this.joins.get(i), value));
                            }
                            continue;
                        }
                        records.add(new Record(object, this.joins.get(i), Collections.emptyMap()));
                        continue;
                    }
                    if (values.isEmpty()) continue;
                    records.add(new Record(object, this.joins.get(i), values.get(0)));
                }
                continue;
            }
            records.add(new Record(object));
        }
        if (!this.groups.isEmpty()) {
            LinkedHashMap<List, List> group = new LinkedHashMap<List, List>();
            for (Record record : records) {
                this.from.setValue(context, scope, record.value);
                if (record.join != null) {
                    record.join.getTarget().setValue(context, scope, record.joinValue);
                }
                List keys = this.groups.stream().map(field -> field.evaluate(context, scope)).collect(Collectors.toList());
                List groupRecords = group.computeIfAbsent(keys, k -> new ArrayList());
                groupRecords.add(record);
            }
            records = new ArrayList();
            for (Map.Entry entry : group.entrySet()) {
                boolean valid;
                List value = (List)entry.getValue();
                Record record = (Record)value.get(0);
                ArrayList<Object> values = new ArrayList<Object>(value.size());
                ArrayList<Object> joinValues = new ArrayList<Object>(value.size());
                for (Record item : value) {
                    values.add(item.value);
                    if (item.join == null) continue;
                    item.join.getTarget().setValue(context, scope, item.joinValue);
                    joinValues.add(item.joinValue);
                }
                boolean bl = valid = this.having == null;
                if (!valid) {
                    this.from.setValue(context, scope, values);
                    valid = BooleanLiteral.isTrue(this.having.evaluate(context, scope));
                }
                if (!valid) continue;
                record.value = values;
                record.joinValue = joinValues;
                records.add(record);
            }
        }
        for (Record record : records) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this.fields.size());
            this.from.setValue(context, scope, record.value);
            if (record.join != null) {
                record.join.getTarget().setValue(context, scope, record.joinValue);
            }
            for (LinqField field2 : this.fields) {
                Object item;
                if (field2.getExpression() instanceof WholeLiteral) {
                    Map map = (Map)record.value;
                    Map map2 = map = map == null ? new LinkedHashMap() : map;
                    if (record.joinValue != null) {
                        map.putAll((Map)record.joinValue);
                    }
                    item = map;
                } else {
                    item = field2.evaluate(context, scope);
                }
                if (item instanceof Map) {
                    linkedHashMap.putAll((Map)item);
                    continue;
                }
                linkedHashMap.put(field2.getAlias(), item);
            }
            ArrayList<OrderValue> orderValues = new ArrayList<OrderValue>();
            if (!this.orders.isEmpty()) {
                for (LinqOrder order : this.orders) {
                    orderValues.add(new OrderValue(order.evaluate(context, scope), order.getOrder()));
                }
            }
            result.add(new SelectValue(linkedHashMap, orderValues));
        }
        return result.stream().sorted().map(SelectValue::getValue).collect(Collectors.toList());
    }

    static class OrderValue {
        private Object value;
        private int order;

        public OrderValue(Object value, int order) {
            this.value = value;
            this.order = order;
        }

        public Object getValue() {
            return this.value;
        }

        public int getOrder() {
            return this.order;
        }
    }

    static class SelectValue
    implements Comparable<SelectValue> {
        Map<String, Object> value;
        List<OrderValue> orderValues;
        boolean hasOrder;

        public SelectValue(Map<String, Object> value, List<OrderValue> orderValues) {
            this.value = value;
            this.orderValues = orderValues;
            this.hasOrder = !orderValues.isEmpty();
        }

        public Map<String, Object> getValue() {
            return this.value;
        }

        @Override
        public int compareTo(SelectValue o2) {
            if (!this.hasOrder) {
                return 0;
            }
            int size = this.orderValues.size();
            for (int i = 0; i < size; ++i) {
                OrderValue ov1 = this.orderValues.get(i);
                OrderValue ov2 = o2.orderValues.get(i);
                int compareValue = BinaryOperation.compare(ov1.getValue(), ov2.getValue());
                if (compareValue == 0) continue;
                return compareValue * ov1.getOrder();
            }
            return 0;
        }
    }

    static class Record {
        private Object value;
        private LinqJoin join;
        private Object joinValue;

        public Record(Object value) {
            this.value = value;
        }

        public Record(Object value, LinqJoin join, Object joinValue) {
            this.value = value;
            this.join = join;
            this.joinValue = joinValue;
        }

        public String toString() {
            return "Record{value=" + this.value + ", join=" + this.join + ", joinValue=" + this.joinValue + '}';
        }
    }
}

