/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.runtime.ExitValue;

public class Assert
extends Node {
    private final Expression condition;
    private final List<Expression> expressions;

    public Assert(Span span, Expression condition, List<Expression> expressions) {
        super(span);
        this.condition = condition;
        this.expressions = expressions;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object value = this.condition.evaluate(context, scope);
        if (!BooleanLiteral.isTrue(value)) {
            Object[] values = new Object[this.expressions.size()];
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                values[i] = this.expressions.get(i).evaluate(context, scope);
            }
            throw new MagicExitException(new ExitValue(values));
        }
        return value;
    }
}

