/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;

public class ClassConverter
extends Expression {
    private final Expression target;
    private final String convert;
    private final List<Expression> arguments;
    private static final Map<String, BiFunction<Object, Object[], Object>> converters = new HashMap<String, BiFunction<Object, Object[], Object>>();

    private static void register(String target, Function<BigDecimal, Object> converter) {
        ClassConverter.register(target, (Object value, Object[] params) -> {
            try {
                return converter.apply(ObjectConvertExtension.asDecimal(value));
            }
            catch (Exception e) {
                return ((Object[])params).length > 0 ? params[0] : null;
            }
        });
    }

    private static Object process(Supplier<Object> callback, Object[] params) {
        try {
            return callback.get();
        }
        catch (Exception e) {
            return params.length > 0 ? params[0] : null;
        }
    }

    public ClassConverter(Span span, String convert, Expression target, List<Expression> arguments) {
        super(span);
        this.convert = convert;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        BiFunction<Object, Object[], Object> function = converters.get(this.convert);
        if (function == null) {
            MagicScriptError.error(String.format("\u627e\u4e0d\u5230\u8f6c\u6362\u5668[%s]", this.convert), this.getSpan());
        }
        return function.apply(this.target.evaluate(context, scope), this.arguments.stream().map(it -> it.evaluate(context, scope)).toArray());
    }

    public static void register(String target, BiFunction<Object, Object[], Object> converter) {
        converters.put(target, converter);
    }

    static {
        ClassConverter.register("int", BigDecimal::intValue);
        ClassConverter.register("double", BigDecimal::doubleValue);
        ClassConverter.register("long", BigDecimal::longValue);
        ClassConverter.register("byte", Number::byteValue);
        ClassConverter.register("float", BigDecimal::floatValue);
        ClassConverter.register("short", Number::shortValue);
        ClassConverter.register("string", (Object target, Object[] params) -> ClassConverter.process(target::toString, params));
        ClassConverter.register("date", (Object target, Object[] params) -> {
            try {
                if (((Object[])params).length == 0) {
                    throw new IllegalArgumentException("::date\u9700\u8981\u65e5\u671f\u683c\u5f0f\uff0c\u5982::date('yyyy-mm-dd')");
                }
                return ObjectConvertExtension.asDate(target, params[0].toString());
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

