/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.ModuleNotFoundException;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;

public class Import
extends Node {
    private String packageName;
    private VarIndex varIndex;
    private boolean module;
    private boolean function;

    public Import(Span span, String packageName, VarIndex varIndex, boolean module) {
        super(span);
        this.packageName = packageName;
        this.varIndex = varIndex;
        this.module = module;
        if (!module && packageName.startsWith("@")) {
            this.function = true;
            this.packageName = packageName.substring(1);
        }
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object target;
        if (this.packageName.endsWith(".*")) {
            context.addImport(this.packageName.substring(0, this.packageName.length() - 1));
            return null;
        }
        if (this.module) {
            target = MagicResourceLoader.loadModule(this.packageName);
            if (target == null) {
                throw new ModuleNotFoundException(String.format("module [%s] not found.", this.packageName), this.getSpan());
            }
        } else if (this.function) {
            target = MagicResourceLoader.loadFunction(this.packageName);
            if (target == null) {
                throw new ModuleNotFoundException(String.format("function [%s] not found.", this.packageName), this.getSpan());
            }
        } else {
            target = MagicResourceLoader.loadClass(this.packageName);
            if (target == null) {
                throw new ModuleNotFoundException(String.format("class [%s] not found.", this.packageName), this.getSpan());
            }
        }
        scope.setValue(this.varIndex, target);
        return null;
    }

    public boolean isFunction() {
        return this.function;
    }
}

