/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.interpreter.AstInterpreter;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Return;

public class LambdaFunction
extends Expression {
    private List<VarIndex> parameters;
    private List<Node> childNodes;
    private int varCount;

    public LambdaFunction(Span span, List<VarIndex> parameters, int varCount, List<Node> childNodes) {
        super(span);
        this.parameters = parameters;
        this.childNodes = childNodes;
        this.varCount = varCount;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        return args -> {
            Object[] arguments = args == null ? new Object[]{} : (args.getClass().isArray() ? (Object[])args : new Object[]{args});
            return this.evaluate(context, scope.create(this.varCount), arguments);
        };
    }

    public List<VarIndex> getParameters() {
        return this.parameters;
    }

    public int getVarCount() {
        return this.varCount;
    }

    Object evaluate(MagicScriptContext context, Scope scope, Object[] args) {
        for (int i = 0; i < this.parameters.size() && i < args.length; ++i) {
            scope.setValue(this.parameters.get(i), args[i]);
        }
        Object value = AstInterpreter.interpretNodeList(this.childNodes, context, scope);
        if (value instanceof Return.ReturnValue) {
            value = ((Return.ReturnValue)value).getValue();
        }
        return value;
    }
}

