/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;

public class MapOrArrayAccess
extends Expression
implements VariableSetter {
    private final Expression mapOrArray;
    private final Expression keyOrIndex;

    public MapOrArrayAccess(Span span, Expression mapOrArray, Expression keyOrIndex) {
        super(span);
        this.mapOrArray = mapOrArray;
        this.keyOrIndex = keyOrIndex;
    }

    public Expression getMapOrArray() {
        return this.mapOrArray;
    }

    public Expression getKeyOrIndex() {
        return this.keyOrIndex;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object keyOrIndex;
        Object mapOrArray = this.getMapOrArray().evaluate(context, scope);
        if (mapOrArray == null) {
            MagicScriptError.error(String.format("\u5bf9\u8c61[%s]\u4e3a\u7a7a", this.getMapOrArray().getSpan().getText()), this.getMapOrArray().getSpan());
        }
        if ((keyOrIndex = this.getKeyOrIndex().evaluate(context, scope)) == null) {
            return null;
        }
        if (mapOrArray instanceof Map) {
            return ((Map)mapOrArray).get(keyOrIndex);
        }
        if (mapOrArray instanceof List) {
            if (!(keyOrIndex instanceof Number)) {
                MagicScriptError.error("List index must be an integer, but was " + keyOrIndex.getClass().getSimpleName(), this.getKeyOrIndex().getSpan());
            }
            int index = ((Number)keyOrIndex).intValue();
            return ((List)mapOrArray).get(index);
        }
        if (!(keyOrIndex instanceof Number)) {
            MagicScriptError.error("Array index must be an integer, but was " + keyOrIndex.getClass().getSimpleName(), this.getKeyOrIndex().getSpan());
        }
        int index = ((Number)keyOrIndex).intValue();
        if (mapOrArray instanceof int[]) {
            return ((int[])mapOrArray)[index];
        }
        if (mapOrArray instanceof float[]) {
            return Float.valueOf(((float[])mapOrArray)[index]);
        }
        if (mapOrArray instanceof double[]) {
            return ((double[])mapOrArray)[index];
        }
        if (mapOrArray instanceof boolean[]) {
            return ((boolean[])mapOrArray)[index];
        }
        if (mapOrArray instanceof char[]) {
            return Character.valueOf(((char[])mapOrArray)[index]);
        }
        if (mapOrArray instanceof short[]) {
            return ((short[])mapOrArray)[index];
        }
        if (mapOrArray instanceof long[]) {
            return ((long[])mapOrArray)[index];
        }
        if (mapOrArray instanceof byte[]) {
            return ((byte[])mapOrArray)[index];
        }
        if (mapOrArray instanceof String) {
            return Character.toString(((String)mapOrArray).charAt(index));
        }
        try {
            return ((Object[])mapOrArray)[index];
        }
        catch (Exception e) {
            MagicScriptError.error("value must be Map or List or Array", this.getSpan(), e);
            return null;
        }
    }

    @Override
    public void setValue(MagicScriptContext context, Scope scope, Object value) {
        Object keyOrIndex;
        Object mapOrArray = this.getMapOrArray().evaluate(context, scope);
        if (mapOrArray != null && (keyOrIndex = this.getKeyOrIndex().evaluate(context, scope)) != null) {
            if (mapOrArray instanceof Map) {
                ((Map)mapOrArray).put(keyOrIndex, value);
            } else if (mapOrArray instanceof List) {
                if (!(keyOrIndex instanceof Number)) {
                    MagicScriptError.error("List index must be an integer, but was " + keyOrIndex.getClass().getSimpleName(), this.getKeyOrIndex().getSpan());
                }
                int index = ((Number)keyOrIndex).intValue();
                ((List)mapOrArray).set(index, value);
            }
        }
    }
}

