/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.functions.ClassExtension;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;

public class NewStatement
extends Expression {
    private final List<Expression> arguments;
    private final Expression target;

    public NewStatement(Span span, Expression target, List<Expression> arguments) {
        super(span);
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object clazz = this.target.evaluate(context, scope);
        if (clazz instanceof Class) {
            Class cls = (Class)clazz;
            Object[] args = new Object[this.arguments.size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.arguments.get(i).evaluate(context, scope);
            }
            try {
                return ClassExtension.newInstance(cls, args);
            }
            catch (Throwable t) {
                MagicScriptError.error(clazz + " can not newInstance.", this.getSpan(), t);
            }
        } else {
            MagicScriptError.error(clazz + " \u4e0d\u662fclass\u7c7b\u578b", this.getSpan());
        }
        return null;
    }
}

