/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.interpreter.AstInterpreter;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Return;

public class TryStatement
extends Node {
    private final VarIndex exceptionVarNode;
    private final List<Node> tryBlock;
    private final List<Node> catchBlock;
    private final List<Node> finallyBlock;
    private final int tryVarCount;
    private final int catchVarCount;
    private final int finallyVarCount;

    public TryStatement(Span span, VarIndex exceptionVarNode, List<Node> tryBlock, List<Node> catchBlock, List<Node> finallyBlock, int tryVarCount, int catchVarCount, int finallyVarCount) {
        super(span);
        this.exceptionVarNode = exceptionVarNode;
        this.tryBlock = tryBlock;
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
        this.tryVarCount = tryVarCount;
        this.catchVarCount = catchVarCount;
        this.finallyVarCount = finallyVarCount;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        try {
            Object value;
            Object object = value = AstInterpreter.interpretNodeList(this.tryBlock, context, scope.create(this.tryVarCount));
            return object;
        }
        catch (MagicExitException mee) {
            throw mee;
        }
        catch (Throwable throwable) {
            if (this.catchBlock != null && this.catchBlock.size() > 0) {
                Scope catchScope = scope.create(this.catchVarCount);
                if (this.exceptionVarNode != null) {
                    catchScope.setValue(this.exceptionVarNode, throwable);
                }
                Object object = AstInterpreter.interpretNodeList(this.catchBlock, context, catchScope);
                return object;
            }
            throw throwable;
        }
        finally {
            Object value;
            if (this.finallyBlock != null && this.finallyBlock.size() > 0 && (value = AstInterpreter.interpretNodeList(this.finallyBlock, context, scope.create(this.finallyVarCount))) instanceof Return.ReturnValue) {
                return value;
            }
        }
    }
}

