/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.interpreter.AstInterpreter;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.parsing.ast.statement.Break;
import org.ssssssss.script.parsing.ast.statement.Return;

public class WhileStatement
extends Node {
    private final Expression condition;
    private final List<Node> trueBlock;
    private final int varCount;

    public WhileStatement(Span span, Expression condition, List<Node> trueBlock, int varCount) {
        super(span);
        this.condition = condition;
        this.trueBlock = trueBlock;
        this.varCount = varCount;
    }

    @Override
    public Object evaluate(MagicScriptContext context, Scope scope) {
        Object breakOrContinueOrReturn;
        Scope whileScope = scope.create(this.varCount);
        while (BooleanLiteral.isTrue(this.condition.evaluate(context, scope)) && (breakOrContinueOrReturn = AstInterpreter.interpretNodeList(this.trueBlock, context, whileScope)) != Break.BREAK_SENTINEL) {
            if (!(breakOrContinueOrReturn instanceof Return.ReturnValue)) continue;
            return breakOrContinueOrReturn;
        }
        return null;
    }
}

