/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.compile;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.asm.ClassWriter;
import org.ssssssss.script.asm.Handle;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.asm.MethodVisitor;
import org.ssssssss.script.asm.Opcodes;
import org.ssssssss.script.asm.Type;
import org.ssssssss.script.compile.Descriptor;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.binary.AssigmentOperation;
import org.ssssssss.script.parsing.ast.statement.VariableAccess;
import org.ssssssss.script.runtime.MagicScriptRuntime;
import org.ssssssss.script.runtime.RuntimeContext;
import org.ssssssss.script.runtime.Variables;
import org.ssssssss.script.runtime.function.MagicScriptLambdaFunction;
import org.ssssssss.script.runtime.handle.ArithmeticHandle;
import org.ssssssss.script.runtime.handle.BitHandle;
import org.ssssssss.script.runtime.handle.FunctionCallHandle;
import org.ssssssss.script.runtime.handle.OperatorHandle;

public class MagicScriptCompiler
implements Opcodes {
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    private final ClassWriter classWriter;
    private final Long id = COUNTER.getAndIncrement();
    private static final Handle OPERATOR_HANDLE = MagicScriptCompiler.makeHandle(OperatorHandle.class);
    private static final Handle BIT_HANDLE = MagicScriptCompiler.makeHandle(BitHandle.class);
    private static final Handle FUNCTION_HANDLE = MagicScriptCompiler.makeHandle(FunctionCallHandle.class);
    private static final Handle ARITHMETIC_HANDLE = MagicScriptCompiler.makeHandle(ArithmeticHandle.class);
    private final Stack<MethodVisitor> methodVisitors = new Stack();
    private final Stack<List<String>> vars = new Stack();
    private final Stack<Label[]> labelStack = new Stack();
    private final Stack<List<Node>> finallyStack = new Stack();
    private final Set<VarIndex> varIndices;
    private static final int[] ICONST = new int[]{2, 3, 4, 5, 6, 7, 8};
    private final List<Span> spans = new ArrayList<Span>();
    private int functionIndex = 0;
    private int tempIndex = 4;
    private final boolean debug;
    private int lastLineNumber = -1;
    private boolean contextInited = false;

    public MagicScriptCompiler(Set<VarIndex> varIndices, boolean debug) {
        this.varIndices = varIndices;
        this.debug = debug;
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(52, 33, this.getClassName(), null, MagicScriptCompiler.getJvmType(MagicScriptRuntime.class), null);
        this.classWriter.visitSource(this.getClassName() + ".ms", null);
        this.createMethod(1, "<init>", Descriptor.make_descriptor(Void.TYPE, new Class[0]));
        this.load0().invoke(183, MagicScriptRuntime.class, "<init>", Void.TYPE, new Class[0]).insn(177).pop();
        this.createMethod(1, "execute", Descriptor.make_descriptor(Object.class, MagicScriptContext.class));
        this.initContext();
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    public MagicScriptCompiler createMethod(int access, String methodName, String descriptor) {
        MethodVisitor visitor = this.classWriter.visitMethod(access, methodName, descriptor, null, null);
        visitor.visitCode();
        this.methodVisitors.push(visitor);
        this.vars.push(new ArrayList());
        this.finallyStack.push(null);
        this.labelStack.push(new Label[2]);
        return this;
    }

    public int getTempIndex() {
        return this.tempIndex++;
    }

    public int getFunctionIndex() {
        return ++this.functionIndex;
    }

    public MagicScriptCompiler markLabel(Label start, Label end) {
        this.labelStack.push(new Label[]{start, end});
        return this;
    }

    public MagicScriptCompiler exitLabel() {
        this.labelStack.pop();
        return this;
    }

    public MagicScriptCompiler start() {
        return this.jump(167, this.labelStack.peek()[0]);
    }

    public MagicScriptCompiler end() {
        return this.jump(167, this.labelStack.peek()[1]);
    }

    public MagicScriptCompiler visit(Node node) {
        AssigmentOperation operation;
        if (node instanceof AssigmentOperation && (operation = (AssigmentOperation)node).getLeftOperand() instanceof VariableAccess) {
            return this.compile(node, true).compile(operation.getLeftOperand());
        }
        return this.compile(node, false);
    }

    public MagicScriptCompiler compile(Node node) {
        return this.compile(node, false);
    }

    public MagicScriptCompiler lineNumber(Span span) {
        this.spans.add(span);
        MethodVisitor mv = this.self();
        Label label = new Label();
        mv.visitLabel(label);
        mv.visitLineNumber(this.spans.size() - 1, label);
        return this;
    }

    public MagicScriptCompiler loadContext() {
        if (this.contextInited || this.methodVisitors.size() > 1) {
            this.load0().self().visitFieldInsn(180, this.getClassName(), "context", Type.getDescriptor(MagicScriptContext.class));
            return this;
        }
        return this.load1();
    }

    public MagicScriptCompiler newRuntimeContext() {
        return this.typeInsn(187, RuntimeContext.class).insn(89).loadContext().load2().invoke(183, RuntimeContext.class, "<init>", Void.TYPE, MagicScriptContext.class, Variables.class);
    }

    public MagicScriptCompiler compile(Node node, boolean pop) {
        AssigmentOperation operation;
        Span.Line currentLine;
        int line;
        if (node == null) {
            return this.insn(1);
        }
        this.lineNumber(node.getSpan());
        if (this.debug && this.lastLineNumber != (line = (currentLine = node.getSpan().getLine()).getLineNumber())) {
            this.loadContext().visitInt(line).visitInt(currentLine.getStartCol()).visitInt(currentLine.getEndLineNumber()).visitInt(currentLine.getEndCol()).load2().invoke(182, MagicScriptContext.class, "pause", Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Variables.class);
            this.lastLineNumber = line;
        }
        node.compile(this);
        if (node instanceof AssigmentOperation && (operation = (AssigmentOperation)node).getLeftOperand() instanceof VariableSetter && operation.getLeftOperand() instanceof VariableAccess) {
            return this;
        }
        return pop && node instanceof Expression ? this.insn(87) : this;
    }

    public MagicScriptCompiler tryCatch(Label start, Label end, Label handle, Class<?> target) {
        this.self().visitTryCatchBlock(start, end, handle, MagicScriptCompiler.getJvmType(target));
        return this;
    }

    public MagicScriptCompiler visit(List<? extends Node> nodes) {
        nodes.forEach(this::visit);
        return this;
    }

    public MagicScriptCompiler compile(List<? extends Node> nodes) {
        nodes.forEach(it -> this.compile((Node)it, true));
        return this;
    }

    public MagicScriptCompiler load0() {
        this.self().visitVarInsn(25, 0);
        return this;
    }

    public MagicScriptCompiler load1() {
        this.self().visitVarInsn(25, 1);
        return this;
    }

    public void newArrayList() {
        this.typeInsn(187, ArrayList.class).insn(89).invoke(183, ArrayList.class, "<init>", Void.TYPE, new Class[0]);
    }

    public MagicScriptCompiler load2() {
        this.self().visitVarInsn(25, 2);
        return this;
    }

    public MagicScriptCompiler load3() {
        this.self().visitVarInsn(25, 3);
        return this;
    }

    public MagicScriptCompiler load(int index) {
        return this.load2().visitInt(index).invoke(182, Variables.class, "getValue", Object.class, Integer.TYPE);
    }

    public MagicScriptCompiler load(VarIndex varIndex) {
        return this.load(varIndex.getIndex());
    }

    public MagicScriptCompiler load(String name) {
        int index = this.vars.peek().indexOf(name) + 1;
        if (index > 0) {
            return this.load(index);
        }
        this.load1().ldc(name).invoke(182, MagicScriptContext.class, "getEnvironmentValue", Object.class, String.class);
        return this;
    }

    public MagicScriptCompiler label(Label label) {
        this.self().visitLabel(label);
        return this;
    }

    public MagicScriptCompiler jump(int opcode, Label label) {
        this.self().visitJumpInsn(opcode, label);
        return this;
    }

    public MagicScriptCompiler remove(VarIndex varIndex) {
        if (varIndex == null) {
            return this;
        }
        return this.remove(varIndex.getName());
    }

    public MagicScriptCompiler remove(String name) {
        List<String> varList = this.vars.peek();
        int index = varList.indexOf(name);
        if (index > -1) {
            varList.set(index, null);
        }
        return this;
    }

    public MagicScriptCompiler store() {
        return this.invoke(182, Variables.class, "setValue", Void.TYPE, Integer.TYPE, Object.class);
    }

    public MagicScriptCompiler store(VarIndex varIndex) {
        return varIndex.isScoped() ? this.scopeStore() : this.store();
    }

    public MagicScriptCompiler scopeStore() {
        return this.invoke(182, Variables.class, "setScopeValue", Void.TYPE, Integer.TYPE, Object.class);
    }

    public MagicScriptCompiler store(int index) {
        this.self().visitVarInsn(58, index);
        return this;
    }

    public MagicScriptCompiler pre_store(int index) {
        return this.load2().visitInt(index);
    }

    public MagicScriptCompiler pre_store(VarIndex varIndex) {
        return this.pre_store(varIndex.getIndex());
    }

    public MagicScriptCompiler bipush(int value) {
        this.self().visitIntInsn(16, value);
        return this;
    }

    public MagicScriptCompiler typeInsn(int opcode, Class<?> target) {
        this.self().visitTypeInsn(opcode, MagicScriptCompiler.getJvmType(target));
        return this;
    }

    public MagicScriptCompiler operator(String methodName) {
        this.self().visitInvokeDynamicInsn(methodName, MethodType.genericMethodType(2).toMethodDescriptorString(), OPERATOR_HANDLE, 2);
        return this;
    }

    public MagicScriptCompiler bit(String methodName) {
        this.self().visitInvokeDynamicInsn(methodName, MethodType.genericMethodType(2).toMethodDescriptorString(), BIT_HANDLE, 2);
        return this;
    }

    public MagicScriptCompiler lambda(String methodName) {
        this.load0();
        Handle metaFactory = new Handle(6, MagicScriptCompiler.getJvmType(LambdaMetafactory.class), "metafactory", Descriptor.make_descriptor(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class), false);
        String descriptor = Descriptor.make_descriptor(Object.class, Variables.class, Object[].class);
        Handle impl = new Handle(5, this.getClassName(), methodName, descriptor, false);
        this.self().visitInvokeDynamicInsn("apply", "(L" + this.getClassName() + ";)" + Type.getType(MagicScriptLambdaFunction.class).getDescriptor(), metaFactory, Type.getType(descriptor), impl, Type.getType(descriptor));
        this.load2().self().visitMethodInsn(182, this.getClassName(), "createLambda", Descriptor.make_descriptor(MagicScriptLambdaFunction.class, MagicScriptLambdaFunction.class, Variables.class), false);
        return this;
    }

    public MagicScriptCompiler call(String methodName, int arguments) {
        this.self().visitInvokeDynamicInsn(methodName, MethodType.genericMethodType(arguments).toMethodDescriptorString(), FUNCTION_HANDLE, arguments);
        return this;
    }

    public MagicScriptCompiler arithmetic(String methodName) {
        this.self().visitInvokeDynamicInsn(methodName, MethodType.genericMethodType(2).toMethodDescriptorString(), ARITHMETIC_HANDLE, 2);
        return this;
    }

    public MagicScriptCompiler asInteger() {
        return this.invoke(184, Integer.class, "valueOf", Integer.class, Integer.TYPE);
    }

    public MagicScriptCompiler asBoolean() {
        return this.invoke(184, Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
    }

    public MagicScriptCompiler invoke(int opcode, Class<?> target, String method, Class<?> returnType, Class<?> ... argumentTypes) {
        return this.invoke(opcode, target, method, false, returnType, argumentTypes);
    }

    public MagicScriptCompiler invoke(int opcode, Class<?> target, String method, boolean isInterface, Class<?> returnType, Class<?> ... argumentTypes) {
        this.self().visitMethodInsn(opcode, MagicScriptCompiler.getJvmType(target), method, Descriptor.make_descriptor(returnType, argumentTypes), isInterface);
        return this;
    }

    public MagicScriptCompiler ldc(Object value) {
        this.self().visitLdcInsn(value);
        return this;
    }

    public MagicScriptCompiler insn(int opcode) {
        this.self().visitInsn(opcode);
        return this;
    }

    public void intInsn(int opcode, int operand) {
        this.self().visitIntInsn(opcode, operand);
    }

    public MagicScriptCompiler newArray(List<Expression> values) {
        int size = values.size();
        this.visitInt(size).typeInsn(189, Object.class);
        for (int i = 0; i < size; ++i) {
            this.insn(89).visitInt(i).visit(values.get(i)).insn(83);
        }
        return this;
    }

    public MagicScriptCompiler visitInt(int value) {
        if (value >= -1 && value <= 5) {
            this.insn(ICONST[value + 1]);
        } else if (value >= -128 && value <= 127) {
            this.intInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.intInsn(17, value);
        } else {
            this.ldc(value);
        }
        return this;
    }

    private void initContext() {
        if (!this.contextInited) {
            this.load0().load1();
            this.self().visitFieldInsn(181, this.getClassName(), "context", Type.getDescriptor(MagicScriptContext.class));
            this.contextInited = true;
            this.load1().load0().visitInt(this.varIndices.size()).invoke(182, MagicScriptContext.class, "createVariables", Variables.class, MagicScriptRuntime.class, Integer.TYPE).store(2);
        }
    }

    public void loadVars() {
        this.varIndices.stream().filter(VarIndex::isReference).forEach(varIndex -> this.load2().visitInt(varIndex.getIndex()).load1().ldc(varIndex.getName()).invoke(182, MagicScriptContext.class, "getEnvironmentValue", Object.class, String.class).store());
    }

    public String visitMethod(String methodName, Runnable callback) {
        return this.visitMethod(methodName, Collections.emptyList(), Collections.emptyList(), callback);
    }

    public String visitMethod(String methodName, List<Node> childNodes, List<VarIndex> parameters, Runnable callback) {
        childNodes.forEach(it -> it.visitMethod(this));
        int index = this.getFunctionIndex();
        methodName = methodName + "_" + index;
        this.createMethod(2, methodName, Descriptor.make_descriptor(Object.class, Variables.class, Object[].class)).load1().load2().visitInt(index).visitInt(parameters.size()).intInsn(188, 10);
        for (int i = 0; i < parameters.size(); ++i) {
            this.insn(89).visitInt(i).visitInt(parameters.get(i).getIndex()).insn(79);
        }
        this.invoke(182, Variables.class, "copy", Variables.class, Object[].class, Integer.TYPE, int[].class).store(2);
        callback.run();
        this.pop();
        return methodName;
    }

    public String visitMethod(String methodName, List<Node> childNodes, List<VarIndex> parameters) {
        return this.visitMethod(methodName, childNodes, parameters, () -> this.compile(childNodes));
    }

    public List<Node> finallyBlock() {
        if (this.finallyStack.isEmpty()) {
            return null;
        }
        return this.finallyStack.peek();
    }

    public void putHeadFinallyBlock(List<Node> finallyBlock) {
        this.finallyStack.insertElementAt(finallyBlock, 0);
    }

    public void putFinallyBlock(List<Node> finallyBlock) {
        this.finallyStack.push(finallyBlock);
    }

    public List<Node> getFinallyBlock() {
        if (this.finallyStack.isEmpty()) {
            return null;
        }
        return this.finallyStack.pop();
    }

    public MagicScriptCompiler pop() {
        this.getFinallyBlock();
        MethodVisitor visitor = this.methodVisitors.pop();
        visitor.visitInsn(1);
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
        this.vars.pop();
        this.labelStack.pop();
        return this;
    }

    public byte[] bytecode() {
        this.pop();
        this.classWriter.visitEnd();
        return this.classWriter.toByteArray();
    }

    public String getClassName() {
        return "MagicScript_" + this.id;
    }

    private MethodVisitor self() {
        return this.methodVisitors.peek();
    }

    private static String getJvmType(Class<?> target) {
        return target == null ? null : target.getName().replace(".", "/");
    }

    private static Handle makeHandle(Class<?> target) {
        return new Handle(6, MagicScriptCompiler.getJvmType(target), "bootstrap", Descriptor.make_descriptor(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE), false);
    }
}

