/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.functions;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ssssssss.script.annotation.Comment;

public class ObjectConvertExtension {
    @Comment(value="\u5c06\u503c\u8f6c\u6362\u4e3aint\u7c7b\u578b")
    public static int asInt(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") int defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).intValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3adouble\u7c7b\u578b")
    public static double asDouble(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") double defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3along\u7c7b\u578b")
    public static long asLong(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") long defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aString\u7c7b\u578b")
    public static String asString(Object val) {
        return ObjectConvertExtension.asString(val, null);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aDate\u7c7b\u578b\uff0c\u9ed8\u8ba4\u5b57\u7b26\u4e32\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm:ss")
    public static Date asDate(Object val) {
        return ObjectConvertExtension.asDate(val, "yyyy-MM-dd HH:mm:ss");
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aBigDecimal\u7c7b\u578b")
    public static BigDecimal asDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        return new BigDecimal(ObjectConvertExtension.asString(val));
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aBigDecimal\u7c7b\u578b")
    public static BigDecimal asDecimal(Object val, @Comment(name="defaultVal", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") BigDecimal defaultVal) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        try {
            return new BigDecimal(ObjectConvertExtension.asString(val));
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aDate\u7c7b\u578b,\u652f\u6301String\u300110\u4f4d\u300113\u4f4d\u65f6\u95f4\u6233")
    public static Date asDate(Object val, @Comment(name="format", value="\u65e5\u671f\u683c\u5f0f\uff0c\u5982yyyy-MM-dd HH:mm:ss") String format) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            try {
                return new SimpleDateFormat(format).parse(val.toString());
            }
            catch (ParseException e) {
                long longVal = ObjectConvertExtension.asLong(val, -1L);
                if (longVal > 0L) {
                    return ObjectConvertExtension.asDate(longVal, format);
                }
            }
        } else {
            if (val instanceof Date) {
                return (Date)val;
            }
            if (val instanceof Number) {
                Number number = (Number)val;
                if (val.toString().length() == 10) {
                    return new Date(number.longValue() * 1000L);
                }
                if (val.toString().length() == 13) {
                    return new Date(number.longValue());
                }
            }
        }
        return null;
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aString\u7c7b\u578b")
    public static String asString(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") String defaultValue) {
        return val == null ? defaultValue : val.toString();
    }

    @Comment(value="\u5c06\u503c\u8f6c\u6362\u4e3aint\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u65f6\u4e3a0")
    public int asInt(Object val) {
        return ObjectConvertExtension.asInt(val, 0);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3adouble\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u65f6\u4e3a0.0")
    public double asDouble(Object val) {
        return ObjectConvertExtension.asDouble(val, 0.0);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3along\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u65f6\u4e3a0L")
    public long asLong(Object val) {
        return ObjectConvertExtension.asLong(val, 0L);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3abyte\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u65f6\u9ed8\u8ba4\u4e3a0")
    public byte asByte(Object val) {
        return this.asByte(val, (byte)0);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3abyte\u7c7b\u578b")
    public byte asByte(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") byte defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).byteValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3ashort\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u65f6\u9ed8\u8ba4\u4e3a0")
    public short asShort(Object val) {
        return this.asShort(val, (short)0);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3ashort\u7c7b\u578b")
    public short asShort(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") short defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).shortValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3afloat\u7c7b\u578b\uff0c\u8f6c\u6362\u5931\u8d25\u9ed8\u8ba4\u4e3a0.0f")
    public float asFloat(Object val) {
        return this.asFloat(val, 0.0f);
    }

    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3afloat\u7c7b\u578b")
    public float asFloat(Object val, @Comment(name="defaultValue", value="\u8f6c\u6362\u5931\u8d25\u65f6\u7684\u9ed8\u8ba4\u503c") float defaultValue) {
        try {
            return ObjectConvertExtension.asDecimal(val).floatValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

