/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;

public class ClassConverter
extends Expression {
    private static final Map<String, BiFunction<Object, Object[], Object>> CONVERTERS = new HashMap<String, BiFunction<Object, Object[], Object>>();
    private final Expression target;
    private final String convert;
    private final List<Expression> arguments;

    public ClassConverter(Span span, String convert, Expression target, List<Expression> arguments) {
        super(span);
        this.convert = convert;
        this.target = target;
        this.arguments = arguments;
    }

    private static void register(String target, Function<BigDecimal, Object> converter) {
        ClassConverter.register(target, (Object value, Object[] params) -> {
            try {
                BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString().trim());
                return converter.apply(decimal);
            }
            catch (Exception e) {
                return params != null && ((Object[])params).length > 0 ? params[0] : null;
            }
        });
    }

    private static Object process(Supplier<Object> callback, Object[] params) {
        try {
            return callback.get();
        }
        catch (Exception e) {
            return params != null && params.length > 0 ? params[0] : null;
        }
    }

    public static Object process(Object object, String target, Object[] params) {
        try {
            BiFunction<Object, Object[], Object> function = CONVERTERS.get(target);
            if (function == null) {
                throw new MagicScriptException(String.format("\u627e\u4e0d\u5230\u8f6c\u6362\u5668[%s]", target));
            }
            return function.apply(object, params);
        }
        catch (Exception e) {
            return params != null && params.length > 0 ? params[0] : null;
        }
    }

    public static void register(String target, BiFunction<Object, Object[], Object> converter) {
        CONVERTERS.put(target, converter);
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.target.visitMethod(compiler);
        this.arguments.forEach(it -> it.visitMethod(compiler));
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        compiler.visit(this.target).ldc(this.convert).visit(this.arguments).call("type_cast", this.arguments.size() + 2);
    }

    static {
        ClassConverter.register("int", BigDecimal::intValue);
        ClassConverter.register("double", BigDecimal::doubleValue);
        ClassConverter.register("long", BigDecimal::longValue);
        ClassConverter.register("byte", Number::byteValue);
        ClassConverter.register("float", BigDecimal::floatValue);
        ClassConverter.register("short", Number::shortValue);
        ClassConverter.register("string", (Object target, Object[] params) -> ClassConverter.process(target::toString, params));
        ClassConverter.register("date", (Object target, Object[] params) -> {
            try {
                if (((Object[])params).length == 0) {
                    throw new IllegalArgumentException("::date\u9700\u8981\u65e5\u671f\u683c\u5f0f\uff0c\u5982::date('yyyy-mm-dd')");
                }
                return ObjectConvertExtension.asDate(target, params[0].toString());
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

