/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;

public class MemberAccess
extends Expression
implements VariableSetter {
    private final Expression object;
    private final Span name;
    private final boolean optional;
    private final boolean whole;

    public MemberAccess(Expression object, boolean optional, Span name, boolean whole) {
        super(name);
        this.object = object;
        this.name = name;
        this.optional = optional;
        this.whole = whole;
    }

    public boolean isWhole() {
        return this.whole;
    }

    public boolean isOptional() {
        return this.optional || this.object instanceof MemberAccess && ((MemberAccess)this.object).isOptional();
    }

    public Expression getObject() {
        return this.object;
    }

    public Span getName() {
        return this.name;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.object.visitMethod(compiler);
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        compiler.newRuntimeContext().visit(this.object).ldc(this.name.getText()).insn(this.isOptional() ? 4 : 3).asBoolean().insn(3).asBoolean().call("member_access", 5);
    }

    public void compileLinq(MagicScriptCompiler compiler) {
        compiler.newRuntimeContext().visit(this.object).ldc(this.name.getText()).insn(this.optional ? 4 : 3).asBoolean().insn(4).asBoolean().call("member_access", 5);
    }

    @Override
    public void compile_visit_variable(MagicScriptCompiler compiler) {
        compiler.compile(this.object).ldc(this.name.getText());
    }
}

