/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;

public class TryStatement
extends Node {
    private final VarIndex exceptionVarNode;
    private final List<Node> tryBlock;
    private final List<Node> catchBlock;
    private final List<Node> finallyBlock;

    public TryStatement(Span span, VarIndex exceptionVarNode, List<Node> tryBlock, List<Node> catchBlock, List<Node> finallyBlock) {
        super(span);
        this.exceptionVarNode = exceptionVarNode;
        this.tryBlock = tryBlock;
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.tryBlock.forEach(it -> it.visitMethod(compiler));
        this.catchBlock.forEach(it -> it.visitMethod(compiler));
        this.finallyBlock.forEach(it -> it.visitMethod(compiler));
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        Label end = new Label();
        boolean hasCatch = this.exceptionVarNode != null;
        boolean hasFinally = !this.finallyBlock.isEmpty();
        compiler.tryCatch(l0, l1, l1, MagicExitException.class);
        if (hasCatch) {
            compiler.tryCatch(l0, l1, l2, Throwable.class);
        }
        if (hasFinally) {
            compiler.putFinallyBlock(this.finallyBlock);
        }
        compiler.label(l0).compile(this.tryBlock);
        if (hasFinally && compiler.finallyBlock() == this.finallyBlock) {
            compiler.compile(compiler.finallyBlock());
        }
        compiler.jump(167, end);
        compiler.label(l1).insn(191);
        if (hasCatch) {
            compiler.label(l2).store(3).pre_store(this.exceptionVarNode).load3().store(this.exceptionVarNode).compile(this.catchBlock);
            if (hasFinally && compiler.finallyBlock() == this.finallyBlock) {
                compiler.compile(compiler.finallyBlock());
            }
            compiler.jump(167, end);
        }
        while (compiler.finallyBlock() == this.finallyBlock) {
            compiler.getFinallyBlock();
        }
        compiler.label(end);
    }
}

