/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import com.xiaoleilu.hutool.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.exception.LengthOverflowException;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpMultiBodyDecoder;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.KeyValue;
import org.tio.http.common.Method;
import org.tio.http.common.RequestLine;
import org.tio.http.common.utils.HttpParseUtils;

public class HttpRequestDecoder {
    private static Logger log = LoggerFactory.getLogger(HttpRequestDecoder.class);
    public static final int MAX_HEADER_LENGTH = 20480;
    public static final int MAX_LENGTH_OF_LINE = 1024;

    public static HttpRequest decode(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        int initPosition = buffer.position();
        Step step = Step.firstline;
        HashMap<String, String> headers = new HashMap<String, String>();
        int contentLength = 0;
        byte[] bodyBytes = null;
        StringBuilder headerSb = new StringBuilder(512);
        RequestLine firstLine = null;
        while (buffer.hasRemaining()) {
            String line;
            try {
                line = ByteBufferUtils.readLine((ByteBuffer)buffer, null, (Integer)1024);
            }
            catch (LengthOverflowException e) {
                throw new AioDecodeException((Throwable)e);
            }
            int newPosition = buffer.position();
            if (newPosition - initPosition > 20480) {
                throw new AioDecodeException("max http header length 20480");
            }
            if (line == null) {
                return null;
            }
            headerSb.append(line).append("\r\n");
            if ("".equals(line)) {
                String contentLengthStr = (String)headers.get(HttpConst.RequestHeaderKey.Content_Length);
                contentLength = StringUtils.isBlank((CharSequence)contentLengthStr) ? 0 : Integer.parseInt(contentLengthStr);
                int readableLength = buffer.limit() - buffer.position();
                if (readableLength >= contentLength) {
                    step = Step.body;
                    break;
                }
                return null;
            }
            if (step == Step.firstline) {
                firstLine = HttpRequestDecoder.parseRequestLine(line, channelContext);
                step = Step.header;
                continue;
            }
            if (step != Step.header) continue;
            KeyValue keyValue = HttpRequestDecoder.parseHeaderLine(line);
            headers.put(keyValue.getKey(), keyValue.getValue());
        }
        if (step != Step.body) {
            return null;
        }
        if (!headers.containsKey(HttpConst.RequestHeaderKey.Host)) {
            throw new AioDecodeException("there is no host header");
        }
        HttpRequest httpRequest = new HttpRequest(channelContext.getClientNode());
        httpRequest.setChannelContext(channelContext);
        httpRequest.setHttpConfig((HttpConfig)channelContext.getGroupContext().getAttribute("TIO_HTTP_SERVER_CONFIG"));
        httpRequest.setHeaderString(headerSb.toString());
        httpRequest.setRequestLine(firstLine);
        httpRequest.setHeaders(headers);
        httpRequest.setContentLength(contentLength);
        if (contentLength == 0) {
            if (StringUtils.isNotBlank((CharSequence)firstLine.getQuery())) {
                Map<String, Object[]> params = HttpRequestDecoder.decodeParams(firstLine.getQuery(), httpRequest.getCharset(), channelContext);
                httpRequest.setParams(params);
            }
        } else {
            bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpRequest.setBody(bodyBytes);
            HttpRequestDecoder.parseBody(httpRequest, firstLine, bodyBytes, channelContext);
        }
        return httpRequest;
    }

    public static Map<String, Object[]> decodeParams(String paramsStr, String charset, ChannelContext channelContext) {
        String[] keyvalues;
        if (StrUtil.isBlank((CharSequence)paramsStr)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object[]> ret = new HashMap<String, Object[]>();
        for (String keyvalue : keyvalues = StringUtils.split((String)paramsStr, (String)"&")) {
            String[] newExistValue;
            String[] keyvalueArr = StringUtils.split((String)keyvalue, (String)"=");
            if (keyvalueArr.length != 2) continue;
            String key = keyvalueArr[0];
            String value = null;
            try {
                value = URLDecoder.decode(keyvalueArr[1], charset);
            }
            catch (UnsupportedEncodingException e) {
                log.error(channelContext.toString(), (Throwable)e);
            }
            Object[] existValue = (Object[])ret.get(key);
            if (existValue != null) {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
                ret.put(key, newExistValue);
                continue;
            }
            newExistValue = new String[]{value};
            ret.put(key, newExistValue);
        }
        return ret;
    }

    public static void main(String[] args) {
    }

    private static void parseBody(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, ChannelContext channelContext) throws AioDecodeException {
        HttpRequestDecoder.parseBodyFormat(httpRequest, httpRequest.getHeaders());
        HttpConst.RequestBodyFormat bodyFormat = httpRequest.getBodyFormat();
        httpRequest.setBody(bodyBytes);
        if (bodyFormat == HttpConst.RequestBodyFormat.MULTIPART) {
            if (log.isInfoEnabled()) {
                String bodyString = null;
                if (bodyBytes != null && bodyBytes.length > 0) {
                    try {
                        bodyString = new String(bodyBytes, httpRequest.getCharset());
                        log.info("{} multipart body string\r\n{}", (Object)channelContext, (Object)bodyString);
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(channelContext.toString(), (Throwable)e);
                    }
                }
            }
            String initboundary = HttpParseUtils.getPerprotyEqualValue(httpRequest.getHeaders(), HttpConst.RequestHeaderKey.Content_Type, "boundary");
            log.info("{}, initboundary:{}", (Object)channelContext, (Object)initboundary);
            HttpMultiBodyDecoder.decode(httpRequest, firstLine, bodyBytes, initboundary, channelContext);
        } else {
            String bodyString = null;
            if (bodyBytes != null && bodyBytes.length > 0) {
                try {
                    bodyString = new String(bodyBytes, httpRequest.getCharset());
                    httpRequest.setBodyString(bodyString);
                    log.info("{} body string\r\n{}", (Object)channelContext, (Object)bodyString);
                }
                catch (UnsupportedEncodingException e) {
                    log.error(channelContext.toString(), (Throwable)e);
                }
            }
            if (bodyFormat == HttpConst.RequestBodyFormat.URLENCODED) {
                HttpRequestDecoder.parseUrlencoded(httpRequest, firstLine, bodyBytes, bodyString, channelContext);
            }
        }
    }

    public static void parseBodyFormat(HttpRequest httpRequest, Map<String, String> headers) {
        String charset;
        String Content_Type2 = StringUtils.lowerCase((String)headers.get(HttpConst.RequestHeaderKey.Content_Type));
        HttpConst.RequestBodyFormat bodyFormat = null;
        bodyFormat = StringUtils.contains((CharSequence)Content_Type2, (CharSequence)HttpConst.RequestHeaderValue.Content_Type.application_x_www_form_urlencoded) ? HttpConst.RequestBodyFormat.URLENCODED : (StringUtils.contains((CharSequence)Content_Type2, (CharSequence)HttpConst.RequestHeaderValue.Content_Type.multipart_form_data) ? HttpConst.RequestBodyFormat.MULTIPART : HttpConst.RequestBodyFormat.TEXT);
        httpRequest.setBodyFormat(bodyFormat);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Content_Type2}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{charset = HttpParseUtils.getPerprotyEqualValue(headers, HttpConst.RequestHeaderKey.Content_Type, "charset")})) {
            httpRequest.setCharset(charset);
        }
    }

    public static KeyValue parseHeaderLine(String line) {
        KeyValue keyValue = new KeyValue();
        int p = line.indexOf(":");
        if (p == -1) {
            keyValue.setKey(line);
            return keyValue;
        }
        String name = StringUtils.lowerCase((String)line.substring(0, p).trim());
        String value = line.substring(p + 1).trim();
        keyValue.setKey(name);
        keyValue.setValue(value);
        return keyValue;
    }

    public static RequestLine parseRequestLine(String line, ChannelContext channelContext) throws AioDecodeException {
        try {
            int index1 = line.indexOf(32);
            String _method = StringUtils.upperCase((String)line.substring(0, index1));
            Method method = Method.from(_method);
            int index2 = line.indexOf(32, index1 + 1);
            String pathAndQuerystr = line.substring(index1 + 1, index2);
            String path = null;
            String queryStr = null;
            int indexOfQuestionmark = pathAndQuerystr.indexOf("?");
            if (indexOfQuestionmark != -1) {
                queryStr = StringUtils.substring((String)pathAndQuerystr, (int)(indexOfQuestionmark + 1));
                path = StringUtils.substring((String)pathAndQuerystr, (int)0, (int)indexOfQuestionmark);
            } else {
                path = pathAndQuerystr;
                queryStr = "";
            }
            String protocolVersion = line.substring(index2 + 1);
            String[] pv = StringUtils.split((String)protocolVersion, (String)"/");
            String protocol = pv[0];
            String version = pv[1];
            RequestLine requestLine = new RequestLine();
            requestLine.setMethod(method);
            requestLine.setPath(path);
            requestLine.setPathAndQuery(pathAndQuerystr);
            requestLine.setQuery(queryStr);
            requestLine.setVersion(version);
            requestLine.setProtocol(protocol);
            requestLine.setLine(line);
            return requestLine;
        }
        catch (Exception e) {
            log.error(channelContext.toString(), (Throwable)e);
            throw new AioDecodeException((Throwable)e);
        }
    }

    private static void parseUrlencoded(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, String bodyString, ChannelContext channelContext) {
        String paramStr = "";
        if (StringUtils.isNotBlank((CharSequence)firstLine.getQuery())) {
            paramStr = paramStr + firstLine.getQuery();
        }
        if (bodyString != null) {
            if (paramStr != null) {
                paramStr = paramStr + "&";
            }
            paramStr = paramStr + bodyString;
        }
        if (paramStr != null) {
            Map<String, Object[]> params = HttpRequestDecoder.decodeParams(paramStr, httpRequest.getCharset(), channelContext);
            httpRequest.setParams(params);
        }
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

