/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import com.xiaoleilu.hutool.util.ZipUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpPacket;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.RequestLine;

public class HttpResponse
extends HttpPacket {
    private static Logger log = LoggerFactory.getLogger(HttpResponse.class);
    private static final long serialVersionUID = -3512681144230291786L;
    private HttpResponseStatus status = HttpResponseStatus.C200;
    private boolean isStaticRes = false;
    private HttpRequest request = null;
    private List<Cookie> cookies = null;
    private String charset = "utf-8";
    private byte[] encodedBytes = null;

    public static void main(String[] args) {
    }

    public HttpResponse(HttpRequest request, HttpConfig httpConfig) {
        this.request = request;
        String Connection2 = StringUtils.lowerCase((String)request.getHeader(HttpConst.RequestHeaderKey.Connection));
        RequestLine requestLine = request.getRequestLine();
        String version = requestLine.getVersion();
        if ("1.0".equals(version)) {
            if (StringUtils.equals((CharSequence)Connection2, (CharSequence)HttpConst.RequestHeaderValue.Connection.keep_alive)) {
                this.addHeader(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.keep_alive);
                this.addHeader(HttpConst.ResponseHeaderKey.Keep_Alive, "timeout=10, max=20");
            } else {
                this.addHeader(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.close);
            }
        } else if (StringUtils.equals((CharSequence)Connection2, (CharSequence)HttpConst.RequestHeaderValue.Connection.close)) {
            this.addHeader(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.close);
        } else {
            this.addHeader(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.keep_alive);
            this.addHeader(HttpConst.ResponseHeaderKey.Keep_Alive, "timeout=10, max=20");
        }
        if (httpConfig != null) {
            this.addHeader(HttpConst.ResponseHeaderKey.Server, httpConfig.getServerInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCookie(Cookie cookie) {
        if (this.cookies == null) {
            HttpResponse httpResponse = this;
            synchronized (httpResponse) {
                if (this.cookies == null) {
                    this.cookies = new ArrayList<Cookie>();
                }
            }
        }
        return this.cookies.add(cookie);
    }

    public String getCharset() {
        return this.charset;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public byte[] getEncodedBytes() {
        return this.encodedBytes;
    }

    public HttpRequest getHttpRequestPacket() {
        return this.request;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    private void gzip(HttpRequest request) {
        if (request.getIsSupportGzip().booleanValue()) {
            byte[] bs2;
            byte[] bs = this.getBody();
            if (bs.length >= 600 && (bs2 = ZipUtil.gzip((byte[])bs)).length < bs.length) {
                this.body = bs2;
                this.addHeader(HttpConst.ResponseHeaderKey.Content_Encoding, "gzip");
            }
        } else {
            log.info("{} \u7adf\u7136\u4e0d\u652f\u6301gzip, {}", (Object)request.getChannelContext(), (Object)request.getHeader(HttpConst.RequestHeaderKey.User_Agent));
        }
    }

    public boolean isStaticRes() {
        return this.isStaticRes;
    }

    public String logstr() {
        String str = null;
        if (this.request != null) {
            str = "\r\n\u54cd\u5e94: \u8bf7\u6c42ID_" + this.request.getId() + "  " + this.request.getRequestLine().getPathAndQuery();
            str = str + "\r\n" + this.getHeaderString();
        } else {
            str = "\r\n\u54cd\u5e94\r\n" + this.status.getHeaderText();
        }
        return str;
    }

    public void setBody(byte[] body, HttpRequest request) {
        this.body = body;
    }

    public void setBodyAndGzip(byte[] body, HttpRequest request) {
        this.body = body;
        if (body != null) {
            this.gzip(request);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setEncodedBytes(byte[] encodedBytes) {
        this.encodedBytes = encodedBytes;
    }

    public void setHttpRequestPacket(HttpRequest request) {
        this.request = request;
    }

    public void setStaticRes(boolean isStaticRes) {
        this.isStaticRes = isStaticRes;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }
}

