/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common.session;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;

public class HttpSession
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(HttpSession.class);
    private static final long serialVersionUID = 6077020620501316538L;
    private Map<String, Serializable> data = new ConcurrentHashMap<String, Serializable>();
    private String id = null;

    public HttpSession() {
    }

    public HttpSession(String id) {
        this.id = id;
    }

    public void clear(HttpConfig httpConfig) {
        this.data.clear();
        this.update(httpConfig);
    }

    public Object getAttribute(String key) {
        return this.data.get(key);
    }

    public <T> T getAttribute(String key, Class<T> clazz) {
        return (T)this.data.get(key);
    }

    public <T> T getAttribute(String key, Class<T> clazz, T defaultObj) {
        Serializable t = this.data.get(key);
        if (t == null) {
            log.warn("key\u3010{}\u3011'value in session is null", (Object)key);
            return defaultObj;
        }
        return (T)t;
    }

    public String getId() {
        return this.id;
    }

    public void removeAttribute(String key, HttpConfig httpConfig) {
        this.data.remove(key);
        this.update(httpConfig);
    }

    public void setAttribute(String key, Serializable value, HttpConfig httpConfig) {
        this.data.put(key, value);
        this.update(httpConfig);
    }

    public void update(HttpConfig httpConfig) {
        httpConfig.getSessionStore().put(this.id, (Serializable)this);
    }

    public void setId(String id) {
        this.id = id;
    }
}

