/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.token;

import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.http.server.intf.CurrUseridGetter;
import org.tio.http.server.stat.DefaultStatPathFilter;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.token.DefaultTokenGetter;
import org.tio.http.server.stat.token.TokenAccessStat;
import org.tio.http.server.stat.token.TokenGetter;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.http.server.stat.token.TokenPathAccessStatRemovalListener;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.hutool.StrUtil;

public class TokenPathAccessStats {
    private static Logger log = LoggerFactory.getLogger(TokenPathAccessStats.class);
    private static final String CACHE_NAME = "TIO_TOKEN_ACCESSPATH";
    private TioConfig tioConfig;
    private String tioConfigId;
    private StatPathFilter statPathFilter;
    public final Map<Long, CaffeineCache> cacheMap = new HashMap<Long, CaffeineCache>();
    public final List<Long> durationList = new ArrayList<Long>();
    private final Map<Long, TokenPathAccessStatListener> listenerMap = new HashMap<Long, TokenPathAccessStatListener>();
    private TokenGetter tokenGetter;
    private CurrUseridGetter currUseridGetter;

    public TokenPathAccessStats(StatPathFilter statPathFilter, TokenGetter tokenGetter, CurrUseridGetter currUseridGetter, TioConfig tioConfig, TokenPathAccessStatListener tokenPathAccessStatListener, Long[] durations) {
        this.statPathFilter = statPathFilter;
        if (this.statPathFilter == null) {
            this.statPathFilter = DefaultStatPathFilter.me;
        }
        if (tokenGetter == null) {
            throw new RuntimeException("tokenGetter can not be null");
        }
        this.tokenGetter = tokenGetter;
        this.currUseridGetter = currUseridGetter;
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, tokenPathAccessStatListener);
            }
        }
    }

    public TokenPathAccessStats(StatPathFilter statPathFilter, CurrUseridGetter currUseridGetter, TioConfig tioConfig, TokenPathAccessStatListener tokenPathAccessStatListener, Long[] durations) {
        this(statPathFilter, DefaultTokenGetter.me, currUseridGetter, tioConfig, tokenPathAccessStatListener, durations);
    }

    public void addDuration(Long duration, TokenPathAccessStatListener tokenPathAccessStatListener) {
        CaffeineCache caffeineCache = CaffeineCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new TokenPathAccessStatRemovalListener(this.tioConfig, tokenPathAccessStatListener));
        this.cacheMap.put(duration, caffeineCache);
        this.durationList.add(duration);
        if (tokenPathAccessStatListener != null) {
            this.listenerMap.put(duration, tokenPathAccessStatListener);
        }
    }

    public TokenPathAccessStatListener getListener(Long duration) {
        return this.listenerMap.get(duration);
    }

    public void addDurations(Long[] durations, TokenPathAccessStatListener tokenPathAccessStatListener) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, tokenPathAccessStatListener);
            }
        }
    }

    public void removeMonitor(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_TOKEN_ACCESSPATH_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenAccessStat get(Long duration, String token, String ip, String uid, boolean forceCreate) {
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        TokenAccessStat tokenAccessStat = (TokenAccessStat)caffeineCache.get(token);
        if (tokenAccessStat == null && forceCreate) {
            CaffeineCache caffeineCache2 = caffeineCache;
            synchronized (caffeineCache2) {
                tokenAccessStat = (TokenAccessStat)caffeineCache.get(token);
                if (tokenAccessStat == null) {
                    tokenAccessStat = new TokenAccessStat(duration, token, ip, uid);
                    caffeineCache.put(token, (Serializable)tokenAccessStat);
                }
            }
        }
        return tokenAccessStat;
    }

    public TokenAccessStat get(Long duration, String token, String ip, String uid) {
        return this.get(duration, token, ip, uid, true);
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        ConcurrentMap map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }

    public TokenGetter getTokenGetter() {
        return this.tokenGetter;
    }

    public CurrUseridGetter getCurrUseridGetter() {
        return this.currUseridGetter;
    }

    public void setCurrUseridGetter(CurrUseridGetter currUseridGetter) {
        this.currUseridGetter = currUseridGetter;
    }

    public StatPathFilter getStatPathFilter() {
        return this.statPathFilter;
    }

    public void setStatPathFilter(StatPathFilter statPathFilter) {
        this.statPathFilter = statPathFilter;
    }
}

