/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs.hdfs;

import com.google.common.base.Throwables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;
import tachyon.underfs.hdfs.HdfsUnderFileSystemUtils;
import tachyon.util.network.NetworkAddressUtils;

public class HdfsUnderFileSystem
extends UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final int MAX_TRY = 5;
    private FileSystem mFs = null;
    private String mUfsPrefix = null;
    private static final FsPermission PERMISSION = new FsPermission(511).applyUMask(FsPermission.createImmutable((short)0));

    public HdfsUnderFileSystem(String fsDefaultName, TachyonConf tachyonConf, Object conf) {
        super(tachyonConf);
        this.mUfsPrefix = fsDefaultName;
        Configuration tConf = conf != null && conf instanceof Configuration ? (Configuration)conf : new Configuration();
        this.prepareConfiguration(fsDefaultName, tachyonConf, tConf);
        tConf.addResource(new Path(tConf.get("tachyon.underfs.hdfs.configuration")));
        HdfsUnderFileSystemUtils.addS3Credentials(tConf);
        Path path = new Path(this.mUfsPrefix);
        try {
            this.mFs = path.getFileSystem(tConf);
        }
        catch (IOException e) {
            LOG.error("Exception thrown when trying to get FileSystem for " + this.mUfsPrefix, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public UnderFileSystem.UnderFSType getUnderFSType() {
        return UnderFileSystem.UnderFSType.HDFS;
    }

    protected void prepareConfiguration(String path, TachyonConf tachyonConf, Configuration config) {
        String ufsHdfsImpl = this.mTachyonConf.get("tachyon.underfs.hdfs.impl");
        if (!StringUtils.isEmpty((CharSequence)ufsHdfsImpl)) {
            config.set("fs.hdfs.impl", ufsHdfsImpl);
        }
        config.set("fs.hdfs.impl.disable.cache", System.getProperty("fs.hdfs.impl.disable.cache", "false"));
        HdfsUnderFileSystemUtils.addKey(config, tachyonConf, "tachyon.underfs.hdfs.configuration");
    }

    public void close() throws IOException {
        this.mFs.close();
    }

    public FSDataOutputStream create(String path) throws IOException {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                LOG.debug("Creating HDFS file at {}", (Object)path);
                return FileSystem.create((FileSystem)this.mFs, (Path)new Path(path), (FsPermission)PERMISSION);
            }
            catch (IOException e) {
                LOG.error(++cnt + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public FSDataOutputStream create(String path, int blockSizeByte) throws IOException {
        return this.create(path);
    }

    public FSDataOutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        return this.create(path);
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        LOG.debug("deleting {} {}", (Object)path, (Object)recursive);
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.delete(new Path(path), recursive);
            }
            catch (IOException e) {
                LOG.error(++cnt + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public boolean exists(String path) throws IOException {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.exists(new Path(path));
            }
            catch (IOException e) {
                LOG.error(++cnt + " try to check if " + path + " exists " + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public long getBlockSizeByte(String path) throws IOException {
        Path tPath = new Path(path);
        if (!this.mFs.exists(tPath)) {
            throw new FileNotFoundException(path);
        }
        FileStatus fs = this.mFs.getFileStatus(tPath);
        return fs.getBlockSize();
    }

    public Object getConf() {
        return this.mFs.getConf();
    }

    public List<String> getFileLocations(String path) throws IOException {
        return this.getFileLocations(path, 0L);
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FileStatus fStatus = this.mFs.getFileStatus(new Path(path));
            BlockLocation[] bLocations = this.mFs.getFileBlockLocations(fStatus, offset, 1L);
            if (bLocations.length > 0) {
                String[] names = bLocations[0].getNames();
                Collections.addAll(ret, names);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get file location for " + path, (Throwable)e);
        }
        return ret;
    }

    public long getFileSize(String path) throws IOException {
        int cnt = 0;
        Path tPath = new Path(path);
        while (cnt < 5) {
            try {
                FileStatus fs = this.mFs.getFileStatus(tPath);
                return fs.getLen();
            }
            catch (IOException e) {
                LOG.error(++cnt + " try to get file size for " + path + " : " + e.getMessage(), (Throwable)e);
            }
        }
        return -1L;
    }

    public long getModificationTimeMs(String path) throws IOException {
        Path tPath = new Path(path);
        if (!this.mFs.exists(tPath)) {
            throw new FileNotFoundException(path);
        }
        FileStatus fs = this.mFs.getFileStatus(tPath);
        return fs.getModificationTime();
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        if (this.mFs instanceof DistributedFileSystem) {
            switch (type) {
                case SPACE_TOTAL: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getCapacity();
                }
                case SPACE_USED: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getDfsUsed();
                }
                case SPACE_FREE: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getRemaining();
                }
            }
            throw new IOException("Unknown getSpace parameter: " + type);
        }
        return -1L;
    }

    public boolean isFile(String path) throws IOException {
        return this.mFs.isFile(new Path(path));
    }

    public String[] list(String path) throws IOException {
        FileStatus[] files = this.mFs.listStatus(new Path(path));
        if (files != null) {
            String[] rtn = new String[files.length];
            int i = 0;
            for (FileStatus status : files) {
                TachyonURI filePathURI = new TachyonURI(status.getPath().toUri().toString());
                String filePath = NetworkAddressUtils.replaceHostName((TachyonURI)filePathURI).toString();
                rtn[i++] = filePath.substring(path.length());
            }
            return rtn;
        }
        return null;
    }

    public void connectFromMaster(TachyonConf conf, String host) throws IOException {
        if (!conf.containsKey("tachyon.master.keytab.file") || !conf.containsKey("tachyon.master.principal")) {
            return;
        }
        String masterKeytab = conf.get("tachyon.master.keytab.file");
        String masterPrincipal = conf.get("tachyon.master.principal");
        this.login("tachyon.master.keytab.file", masterKeytab, "tachyon.master.principal", masterPrincipal, host);
    }

    public void connectFromWorker(TachyonConf conf, String host) throws IOException {
        if (!conf.containsKey("tachyon.worker.keytab.file") || !conf.containsKey("tachyon.worker.principal")) {
            return;
        }
        String workerKeytab = conf.get("tachyon.worker.keytab.file");
        String workerPrincipal = conf.get("tachyon.worker.principal");
        this.login("tachyon.worker.keytab.file", workerKeytab, "tachyon.worker.principal", workerPrincipal, host);
    }

    private void login(String keytabFileKey, String keytabFile, String principalKey, String principal, String hostname) throws IOException {
        Configuration conf = new Configuration();
        conf.set(keytabFileKey, keytabFile);
        conf.set(principalKey, principal);
        SecurityUtil.login((Configuration)conf, (String)keytabFileKey, (String)principalKey, (String)hostname);
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                if (this.mFs.exists(new Path(path))) {
                    LOG.debug("Trying to create existing directory at {}", (Object)path);
                    return false;
                }
                return this.mFs.mkdirs(new Path(path), PERMISSION);
            }
            catch (IOException e) {
                LOG.error(++cnt + " try to make directory for " + path + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public FSDataInputStream open(String path) throws IOException {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.open(new Path(path));
            }
            catch (IOException e) {
                LOG.error(++cnt + " try to open " + path + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public boolean rename(String src, String dst) throws IOException {
        LOG.debug("Renaming from {} to {}", (Object)src, (Object)dst);
        if (!this.exists(src)) {
            LOG.error("File " + src + " does not exist. Therefore rename to " + dst + " failed.");
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("File " + dst + " does exist. Therefore rename from " + src + " failed.");
            return false;
        }
        int cnt = 0;
        IOException te = null;
        while (cnt < 5) {
            try {
                return this.mFs.rename(new Path(src), new Path(dst));
            }
            catch (IOException e) {
                LOG.error(++cnt + " try to rename " + src + " to " + dst + " : " + e.getMessage(), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public void setConf(Object conf) {
        this.mFs.setConf((Configuration)conf);
    }

    public void setPermission(String path, String posixPerm) throws IOException {
        try {
            FileStatus fileStatus = this.mFs.getFileStatus(new Path(path));
            LOG.info("Changing file '" + fileStatus.getPath() + "' permissions from: " + fileStatus.getPermission() + " to " + posixPerm);
            FsPermission perm = new FsPermission(Short.parseShort(posixPerm));
            this.mFs.setPermission(fileStatus.getPath(), perm);
        }
        catch (IOException e) {
            LOG.error("Fail to set permission for " + path + " with perm " + posixPerm, (Throwable)e);
            throw e;
        }
    }
}

